/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.config.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.SoapResource;
import com.ca.apim.gateway.cagatewayconfig.beans.SoapResourceType;
import com.ca.apim.gateway.cagatewayconfig.config.loader.ConfigLoadException;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoader;
import com.ca.apim.gateway.cagatewayconfig.config.loader.FolderLoaderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class SoapResourceLoader
implements EntityLoader {
    private final FileUtils fileUtils;

    @Inject
    SoapResourceLoader(FileUtils fileUtils) {
        this.fileUtils = fileUtils;
    }

    @Override
    public void load(Bundle bundle, File rootDir) {
        File soapResourceRootDir = FolderLoaderUtils.getSoapResourcesRootDir(rootDir);
        if (soapResourceRootDir == null) {
            return;
        }
        HashMap<String, SoapResource> soapResources = new HashMap<String, SoapResource>();
        this.loadSoapResources(soapResourceRootDir, soapResourceRootDir, soapResources);
        bundle.putAllSoapResources(soapResources);
    }

    @Override
    public void load(Bundle bundle, String name, String value) {
        throw new ConfigLoadException("Cannot load an individual soapResource");
    }

    @Override
    public Map<String, Object> load(File entitiesFile) {
        throw new ConfigLoadException("Cannot load soapResource from config file");
    }

    @Override
    public Object loadSingle(String name, File entitiesFile) {
        throw new ConfigLoadException("Cannot load an individual soapResource");
    }

    private void loadSoapResources(File currentDir, File rootDir, Map<String, SoapResource> soapResources) {
        File[] children = currentDir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    this.loadSoapResources(child, rootDir, soapResources);
                    continue;
                }
                if (!StringUtils.equalsAnyIgnoreCase((CharSequence)("." + FilenameUtils.getExtension((String)child.getName())), (CharSequence[])new CharSequence[]{SoapResourceType.WSDL.getExtension(), SoapResourceType.XMLSCHEMA.getExtension()})) continue;
                SoapResource soapResource = this.loadSoapResource(child, rootDir);
                soapResources.put(soapResource.getPath(), soapResource);
            }
        }
    }

    private SoapResource loadSoapResource(File soapResourceFile, File rootDir) {
        SoapResource soapResource = new SoapResource();
        String soapResourcePath = FolderLoaderUtils.getPath(soapResourceFile, rootDir);
        String soapResourceName = soapResourceFile.getName();
        soapResource.setPath(soapResourcePath);
        soapResource.setName(FilenameUtils.getBaseName((String)soapResourceName));
        soapResource.setContent(this.fileUtils.getFileAsString(soapResourceFile));
        soapResource.setTypeByExtension(FilenameUtils.getExtension((String)soapResourceFile.getName()));
        return soapResource;
    }

    @Override
    public String getEntityType() {
        return "SOAP_RESOURCE";
    }
}

