/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.config.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.config.loader.ConfigLoadException;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoader;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.SupplierWithIO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;

@Singleton
public class PrivateKeyLoader
implements EntityLoader {
    @Override
    public void load(Bundle bundle, File rootDir) {
        String[] privateKeyFiles;
        File privateKeysDir = FileUtils.findConfigFileOrDir(rootDir, "privateKeys");
        if (privateKeysDir != null && privateKeysDir.exists() && (privateKeyFiles = privateKeysDir.list()) != null && privateKeyFiles.length > 0) {
            HashMap<String, SupplierWithIO<InputStream>> map = new HashMap<String, SupplierWithIO<InputStream>>();
            Arrays.stream(privateKeyFiles).forEach(privateKey -> {
                if (!this.checkPrivateKeyFormat((String)privateKey)) {
                    throw new ConfigLoadException(privateKey + " must be a valid private key extension (.p12).");
                }
                map.put(FilenameUtils.getBaseName((String)privateKey), () -> new FileInputStream(new File(privateKeysDir, (String)privateKey)));
            });
            bundle.putAllPrivateKeyFiles(map);
        }
    }

    @Override
    public void load(Bundle bundle, String name, String value) {
        if (!this.checkPrivateKeyFormat(name)) {
            throw new ConfigLoadException(name + " must be a valid private key extension (.p12).");
        }
        bundle.getPrivateKeyFiles().put(name.substring(0, name.length() - 4), () -> new ByteArrayInputStream(Base64.decodeBase64((String)value)));
    }

    @Override
    public Object loadSingle(String name, File entitiesFile) {
        if (!this.checkPrivateKeyFormat(entitiesFile.getName())) {
            throw new ConfigLoadException(name + " must be a valid private key extension (.p12).");
        }
        try {
            return Base64.encodeBase64String((byte[])org.apache.commons.io.FileUtils.readFileToByteArray((File)entitiesFile));
        }
        catch (IOException e) {
            throw new ConfigLoadException("Cannot load private key " + name);
        }
    }

    @Override
    public Map<String, Object> load(File entitiesFile) {
        throw new ConfigLoadException("Cannot load private keys from " + entitiesFile);
    }

    private boolean checkPrivateKeyFormat(String certFileName) {
        return certFileName.toLowerCase().endsWith(".p12");
    }

    @Override
    public String getEntityType() {
        return "PRIVATE_KEY_FILE";
    }
}

