/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.config.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.Folderable;
import com.ca.apim.gateway.cagatewayconfig.config.loader.ConfigLoadException;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class FolderLoaderUtils {
    public static final String SOAP_RESOURCES_FOLDER = "soapResources";

    public static <E extends Folderable> void createFolders(Bundle bundle, File rootDir, Map<String, E> folderableMap) {
        File policyRootDir = FolderLoaderUtils.getPolicyRootDir(rootDir);
        if (policyRootDir == null) {
            return;
        }
        Map<String, Folder> folderMap = bundle.getFolders();
        Folder rootFolder = folderMap.computeIfAbsent(FolderLoaderUtils.getPath(policyRootDir, policyRootDir), key -> FolderLoaderUtils.createFolder(policyRootDir.getName(), key, null));
        folderableMap.forEach((folderablePath, folderable) -> {
            String pathExcludingService = FilenameUtils.getFullPath((String)folderablePath);
            if (StringUtils.isEmpty((CharSequence)pathExcludingService)) {
                folderable.setParentFolder(rootFolder);
            } else {
                FolderLoaderUtils.createFoldersAlongPath(pathExcludingService, folderMap, rootFolder);
                folderable.setParentFolder((Folder)folderMap.get(pathExcludingService));
            }
        });
    }

    @Nullable
    static File getPolicyRootDir(File rootDir) {
        File policyRootDir = new File(rootDir, "policy");
        if (!policyRootDir.exists()) {
            return null;
        }
        if (!policyRootDir.isDirectory()) {
            throw new ConfigLoadException("Expected directory but was file: " + policyRootDir);
        }
        return policyRootDir;
    }

    @Nullable
    static File getSoapResourcesRootDir(File rootDir) {
        File soapResourceRootDir = new File(rootDir, SOAP_RESOURCES_FOLDER);
        if (!soapResourceRootDir.exists()) {
            return null;
        }
        if (!soapResourceRootDir.isDirectory()) {
            throw new ConfigLoadException("Expected directory but was file: " + soapResourceRootDir);
        }
        return soapResourceRootDir;
    }

    static void createFoldersAlongPath(String stringPath, Map<String, Folder> folderMap, Folder rootFolder) {
        Path path = Paths.get(stringPath, new String[0]);
        ArrayList<Path> paths = new ArrayList<Path>();
        int i = 0;
        while (i < path.getNameCount()) {
            paths.add(path.subpath(0, ++i));
        }
        for (Path p : paths) {
            Folder parentFolder = p.getParent() == null ? rootFolder : folderMap.get(PathUtils.unixPathEndingWithSeparator(p.getParent()));
            folderMap.computeIfAbsent(PathUtils.unixPathEndingWithSeparator(p), key -> FolderLoaderUtils.createFolder(p.getFileName().toString(), key, parentFolder));
        }
    }

    static Folder createFolder(String folderName, String folderPath, Folder parentFolder) {
        Folder folder = new Folder();
        folder.setName(folderName);
        folder.setPath(folderPath);
        folder.setParentFolder(parentFolder);
        return folder;
    }

    static String getPath(File policy, File policyRootDir) {
        String path = policyRootDir.toURI().relativize(policy.toURI()).getPath();
        if (policy.isFile() || path.isEmpty()) {
            return PathUtils.unixPath(path, new String[0]);
        }
        return PathUtils.unixPathEndingWithSeparator(path, new String[0]);
    }

    private FolderLoaderUtils() {
    }
}

