/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.config.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.EntityUtils;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoader;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoaderBase;
import com.ca.apim.gateway.cagatewayconfig.config.loader.PropertiesLoaderBase;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.json.JsonTools;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EntityLoaderUtils {
    private EntityLoaderUtils() {
    }

    @NotNull
    public static EntityLoader createEntityLoader(JsonTools jsonTools, IdGenerator idGenerator, final EntityUtils.GatewayEntityInfo entityInfo) {
        return new EntityLoaderBase<GatewayEntity>(jsonTools, idGenerator){

            @Override
            public String getEntityType() {
                return entityInfo.getEnvironmentType();
            }

            @Override
            protected Class<GatewayEntity> getBeanClass() {
                return entityInfo.getEntityClass();
            }

            @Override
            protected String getFileName() {
                return entityInfo.getFileName();
            }

            @Override
            protected void putToBundle(Bundle bundle, @NotNull Map<String, GatewayEntity> entitiesMap) {
                bundle.getEntities(entityInfo.getEntityClass()).putAll(entitiesMap);
            }
        };
    }

    @NotNull
    static PropertiesLoaderBase createPropertiesLoader(FileUtils fileUtils, IdGenerator idGenerator, final EntityUtils.GatewayEntityInfo entityInfo) {
        return new PropertiesLoaderBase(fileUtils, idGenerator){

            @Override
            public String getEntityType() {
                return entityInfo.getEnvironmentType();
            }

            @Override
            protected String getFileName() {
                return entityInfo.getFileName() + ".properties";
            }

            protected Class getEntityClass() {
                return entityInfo.getEntityClass();
            }
        };
    }

    static <B> Map<String, B> loadEntitiesFromFile(JsonTools jsonTools, Class<? extends GatewayEntity> entityClass, File entitiesFile) {
        String fileType = jsonTools.getTypeFromFile(entitiesFile);
        MapType type = jsonTools.getObjectMapper(fileType).getTypeFactory().constructMapType(LinkedHashMap.class, String.class, entityClass);
        return (Map)jsonTools.readDocumentFile(entitiesFile, (JavaType)type);
    }
}

