/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.config.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.config.loader.ConfigLoadException;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoader;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.SupplierWithIO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

@Singleton
public class CertificatesLoader
implements EntityLoader {
    private FileUtils fileUtils;

    @Inject
    CertificatesLoader(FileUtils fileUtils) {
        this.fileUtils = fileUtils;
    }

    @Override
    public void load(Bundle bundle, File rootDir) {
        String[] certs;
        File certificatesDir = FileUtils.findConfigFileOrDir(rootDir, "certificates");
        if (certificatesDir != null && certificatesDir.exists() && (certs = certificatesDir.list()) != null && certs.length > 0) {
            HashMap<String, SupplierWithIO<InputStream>> map = new HashMap<String, SupplierWithIO<InputStream>>();
            Arrays.stream(certs).forEach(cert -> {
                if (!this.checkCertFormat((String)cert)) {
                    throw new ConfigLoadException(cert + " must be a valid certificate extension.");
                }
                map.put(FilenameUtils.getBaseName((String)cert), () -> new FileInputStream(new File(certificatesDir, (String)cert)));
            });
            bundle.putAllCertificateFiles(map);
        }
    }

    @Override
    public void load(Bundle bundle, String name, String value) {
        if (!this.checkCertFormat(name)) {
            throw new ConfigLoadException(name + " must have a valid certificate extension.");
        }
        bundle.getCertificateFiles().put(name.substring(0, name.length() - 4), () -> IOUtils.toInputStream((String)value, (Charset)Charset.defaultCharset()));
    }

    @Override
    public Object loadSingle(String name, File entitiesFile) {
        if (!this.checkCertFormat(entitiesFile.getName())) {
            throw new ConfigLoadException(name + " must have a valid certificate extension.");
        }
        return this.fileUtils.getFileAsString(entitiesFile);
    }

    @Override
    public Map<String, Object> load(File entitiesFile) {
        throw new ConfigLoadException("Cannot load certificates from config file");
    }

    private boolean checkCertFormat(String certFileName) {
        String lowerCaseName = certFileName.toLowerCase();
        return lowerCaseName.endsWith(".der") || lowerCaseName.endsWith(".pem") || lowerCaseName.endsWith(".crt") || lowerCaseName.endsWith(".cer");
    }

    @Override
    public String getEntityType() {
        return "CERTIFICATE_FILE";
    }
}

