/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.Folderable;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ServiceAndPolicyLoaderUtil {
    public static final String HANDLE_DUPLICATE_NAMES = "com.ca.apim.export.handleDuplicateNames";

    public static String getPath(Folder parentFolder, String fileName) {
        return PathUtils.unixPath(Paths.get(parentFolder.getPath(), new String[0]).resolve(fileName));
    }

    public static Folder getFolder(Bundle bundle, String folderId) {
        List folderList = bundle.getFolders().values().stream().filter(f -> folderId.equals(f.getId())).collect(Collectors.toList());
        if (folderList.isEmpty()) {
            throw new BundleLoadException("Invalid dependency bundle. Could not find folder with id: " + folderId);
        }
        if (folderList.size() > 1) {
            throw new BundleLoadException("Invalid dependency bundle. Found multiple folders with id: " + folderId);
        }
        return (Folder)folderList.get(0);
    }

    public static String handleDuplicatePathName(Map<String, ? extends Folderable> bundleEntity, Folderable entity) {
        String basePath;
        int duplicateCounter = 2;
        String clonePath = basePath = entity.getPath();
        if (Boolean.getBoolean(HANDLE_DUPLICATE_NAMES)) {
            Folderable service;
            while (bundleEntity.containsKey(clonePath) && !(service = bundleEntity.get(clonePath)).getId().equals(entity.getId()) && service.getParentFolderId().equals(entity.getParentFolderId())) {
                clonePath = basePath + " (" + duplicateCounter + ")";
                ++duplicateCounter;
            }
            return clonePath;
        }
        throw new BundleLoadException("Duplicate name found while exporting string with invalid characters: " + basePath);
    }

    private ServiceAndPolicyLoaderUtil() {
    }
}

