/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.ScheduledTask;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.Map;
import javax.inject.Singleton;
import org.apache.commons.lang3.BooleanUtils;
import org.w3c.dom.Element;

@Singleton
public class ScheduledTaskLoader
implements BundleEntityLoader {
    @Override
    public void load(Bundle bundle, Element element) {
        Element scheduledTask = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:ScheduledTask");
        String policyId = DocumentUtils.getSingleChildElementAttribute(scheduledTask, "l7:PolicyReference", "id");
        String name = DocumentUtils.getSingleChildElementTextContent(scheduledTask, "l7:Name");
        boolean isOneNode = BooleanUtils.toBoolean((String)DocumentUtils.getSingleChildElementTextContent(scheduledTask, "l7:OneNode"));
        String jobType = DocumentUtils.getSingleChildElementTextContent(scheduledTask, "l7:JobType");
        String jobStatus = DocumentUtils.getSingleChildElementTextContent(scheduledTask, "l7:JobStatus");
        String executionDate = DocumentUtils.getSingleChildElementTextContent(scheduledTask, "l7:ExecutionDate");
        String cronExpression = DocumentUtils.getSingleChildElementTextContent(scheduledTask, "l7:CronExpression");
        boolean shouldExecuteOnCreate = BooleanUtils.toBoolean((String)DocumentUtils.getSingleChildElementTextContent(scheduledTask, "l7:ExecuteOnCreate"));
        Map<String, Object> properties = BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(scheduledTask, "l7:Properties", true), "l7:Properties");
        ScheduledTask task = new ScheduledTask();
        task.setId(scheduledTask.getAttribute("id"));
        task.setPolicy(policyId);
        task.setName(name);
        task.setOneNode(isOneNode);
        task.setJobType(jobType);
        task.setJobStatus(jobStatus);
        task.setExecutionDate(executionDate);
        task.setCronExpression(cronExpression);
        task.setShouldExecuteOnCreate(shouldExecuteOnCreate);
        task.setProperties(properties);
        bundle.getScheduledTasks().put(name, task);
    }

    @Override
    public String getEntityType() {
        return "SCHEDULED_TASK";
    }
}

