/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.KeyStoreType;
import com.ca.apim.gateway.cagatewayconfig.beans.PrivateKey;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.Map;
import javax.inject.Singleton;
import org.w3c.dom.Element;

@Singleton
public class PrivateKeyLoader
implements BundleEntityLoader {
    @Override
    public void load(Bundle bundle, Element element) {
        Element privateKey = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:PrivateKey");
        String alias = privateKey.getAttribute("alias");
        KeyStoreType keystore = KeyStoreType.fromId(privateKey.getAttribute("keystoreId"));
        Map<String, Object> properties = BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(privateKey, "l7:Properties"), "l7:Properties");
        PrivateKey key = new PrivateKey();
        key.setId(keystore.generateKeyId(alias));
        key.setAlias(alias);
        key.setKeyStoreType(keystore);
        key.setKeystore(keystore.getName());
        key.setAlgorithm((String)properties.get("keyAlgorithm"));
        key.setKeyPassword("");
        bundle.getPrivateKeys().put(alias, key);
    }

    @Override
    public String getEntityType() {
        return "SSG_KEY_ENTRY";
    }
}

