/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.AuditPolicy;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.GlobalPolicy;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.beans.PolicyType;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadingOperation;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.ServiceAndPolicyLoaderUtil;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.string.CharacterBlacklistUtil;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.w3c.dom.Element;

@Singleton
public class PolicyLoader
implements BundleEntityLoader {
    private static final Logger LOGGER = Logger.getLogger(PolicyLoader.class.getName());

    @Override
    public void load(Bundle bundle, Element element) {
        Policy policyWithSameName;
        Element policyElement = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:Policy");
        String guid = policyElement.getAttribute("guid");
        Element policyDetails = DocumentUtils.getSingleChildElement(policyElement, "l7:PolicyDetail");
        String policyType = DocumentUtils.getSingleChildElementTextContent(policyDetails, "l7:PolicyType");
        Map<String, Object> policyDetailProperties = BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(policyDetails, "l7:Properties", true), "l7:Properties");
        String policyTag = (String)policyDetailProperties.get("tag");
        boolean hasRouting = false;
        if (policyDetailProperties.get("hasRouting") != null) {
            hasRouting = BooleanUtils.toBoolean((String)policyDetailProperties.get("hasRouting").toString());
        }
        if (!PolicyType.isValidType(policyType, policyTag)) {
            LOGGER.log(Level.WARNING, () -> {
                if (policyTag != null) {
                    return String.format("Skipping unsupported PolicyType: %s, with tag %s", policyType, policyTag);
                }
                return String.format("Skipping unsupported PolicyType: %s", policyType);
            });
            return;
        }
        String id = policyDetails.getAttribute("id");
        String folderId = policyDetails.getAttribute("folderId");
        Element nameElement = DocumentUtils.getSingleChildElement(policyDetails, "l7:Name");
        String name = CharacterBlacklistUtil.filterAndReplace(nameElement.getTextContent());
        Element resources = DocumentUtils.getSingleChildElement(policyElement, "l7:Resources");
        Element resourceSet = DocumentUtils.getSingleChildElement(resources, "l7:ResourceSet");
        Element resource = DocumentUtils.getSingleChildElement(resourceSet, "l7:Resource");
        String policyString = resource.getTextContent();
        PolicyType type = PolicyType.fromType(policyType);
        String policySubtag = (String)policyDetailProperties.get("subtag");
        Folder parentFolder = ServiceAndPolicyLoaderUtil.getFolder(bundle, folderId);
        Policy policy = type.createPolicyObject();
        policy.setPath(ServiceAndPolicyLoaderUtil.getPath(parentFolder, name));
        policy.setName(name);
        policy.setParentFolder(parentFolder);
        policy.setGuid(guid);
        policy.setId(id);
        policy.setTag(policyTag);
        policy.setSubtag(policySubtag);
        policy.setPolicyType(type);
        policy.setPolicyDocument(policyElement);
        policy.setPolicyXML(policyString);
        policy.setHasRouting(hasRouting);
        Map<String, Policy> bundlePolicies = bundle.getPolicies();
        if (bundle.getLoadingMode() == BundleLoadingOperation.VALIDATE && (policyWithSameName = (Policy)bundle.getPolicies().values().stream().filter(p -> Objects.equals(policy.getName(), p.getName())).findAny().orElse(null)) != null) {
            throw new BundleLoadException("Duplicate policies found with name '" + policyWithSameName.getName() + "': " + Joiner.on((String)", ").join(Arrays.asList(policyWithSameName.getPath(), policy.getPath())));
        }
        if (bundlePolicies.containsKey(policy.getPath())) {
            String duplicatePathName = ServiceAndPolicyLoaderUtil.handleDuplicatePathName(bundlePolicies, policy);
            policy.setName(duplicatePathName.substring(duplicatePathName.lastIndexOf(47) + 1));
            policy.setPath(duplicatePathName);
        }
        bundle.getPolicies().put(policy.getPath(), policy);
        if (type == PolicyType.GLOBAL) {
            bundle.getEntities(GlobalPolicy.class).put(policy.getPath(), (GlobalPolicy)policy);
        } else if (type == PolicyType.INTERNAL && ((String)ObjectUtils.firstNonNull((Object[])new String[]{policyTag, ""})).startsWith("audit")) {
            bundle.getEntities(AuditPolicy.class).put(policy.getPath(), (AuditPolicy)policy);
        }
    }

    @Override
    public String getEntityType() {
        return "POLICY";
    }
}

