/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.PolicyBackedService;
import com.ca.apim.gateway.cagatewayconfig.beans.PolicyBackedServiceOperation;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Singleton
public class PolicyBackedServiceLoader
implements BundleEntityLoader {
    @Override
    public void load(Bundle bundle, Element element) {
        Element policyBackedService = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:PolicyBackedService");
        Element nameElement = DocumentUtils.getSingleChildElement(policyBackedService, "l7:Name");
        String name = nameElement.getTextContent();
        Element interfaceNameElement = DocumentUtils.getSingleChildElement(policyBackedService, "l7:InterfaceName");
        String interfaceName = interfaceNameElement.getTextContent();
        PolicyBackedService pbs = new PolicyBackedService();
        pbs.setId(policyBackedService.getAttribute("id"));
        pbs.setName(name);
        pbs.setInterfaceName(interfaceName);
        pbs.setOperations(this.buildOperations(policyBackedService));
        bundle.getPolicyBackedServices().put(name, pbs);
    }

    private Set<PolicyBackedServiceOperation> buildOperations(Element policyBackedService) {
        LinkedHashSet<PolicyBackedServiceOperation> operations = new LinkedHashSet<PolicyBackedServiceOperation>();
        Element policyBackedServiceOperationsElement = DocumentUtils.getSingleChildElement(policyBackedService, "l7:PolicyBackedServiceOperations");
        NodeList policyBackedServiceOperationNodeList = policyBackedServiceOperationsElement.getElementsByTagName("l7:PolicyBackedServiceOperation");
        for (int i = 0; i < policyBackedServiceOperationNodeList.getLength(); ++i) {
            if (!(policyBackedServiceOperationNodeList.item(i) instanceof Element)) {
                throw new BundleLoadException("Unexpected Policy Backed Service Operation node: " + policyBackedServiceOperationsElement.getClass());
            }
            Element policyIdElement = DocumentUtils.getSingleChildElement((Element)policyBackedServiceOperationNodeList.item(i), "l7:PolicyId");
            Element operationNameElement = DocumentUtils.getSingleChildElement((Element)policyBackedServiceOperationNodeList.item(i), "l7:OperationName");
            operations.add(new PolicyBackedServiceOperation(operationNameElement.getTextContent(), policyIdElement.getTextContent()));
        }
        return operations;
    }

    @Override
    public String getEntityType() {
        return "POLICY_BACKED_SERVICE";
    }
}

