/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.ServiceAndPolicyLoaderUtil;
import com.ca.apim.gateway.cagatewayconfig.util.string.CharacterBlacklistUtil;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.w3c.dom.Element;

@Singleton
public class FolderLoader
implements BundleEntityLoader {
    private static final Logger LOGGER = Logger.getLogger(FolderLoader.class.getName());

    @Override
    public void load(Bundle bundle, Element element) {
        Element folderElement = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:Folder");
        String name = DocumentUtils.getSingleChildElementTextContent(folderElement, "l7:Name");
        String id = folderElement.getAttribute("id");
        String parentFolderID = folderElement.getAttribute("folderId");
        Folder parentFolder = "0000000000000000ffffffffffffec76".equals(id) ? null : ServiceAndPolicyLoaderUtil.getFolder(bundle, parentFolderID);
        name = CharacterBlacklistUtil.encodeName(name);
        Folder folder = new Folder();
        folder.setId(id);
        folder.setName(name);
        folder.setParentFolder(parentFolder);
        folder.setPath(this.getPath(folder).toString());
        bundle.getFolders().put(folder.getPath(), folder);
    }

    private Path getPath(Folder folder) {
        if (folder.getParentFolder() == null || "0000000000000000ffffffffffffec76".equals(folder.getParentFolder().getId())) {
            return Paths.get(folder.getName(), new String[0]);
        }
        return this.getPath(folder.getParentFolder()).resolve(folder.getName());
    }

    @Override
    public String getEntityType() {
        return "FOLDER";
    }
}

