/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotableEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleDefinedEntities;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.DefaultMetadata;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Metadata;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoaderRegistry;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadingOperation;
import com.ca.apim.gateway.cagatewayconfig.util.file.JsonFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.ArrayUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Singleton
public class EntityBundleLoader {
    private static final Logger LOGGER = Logger.getLogger(EntityBundleLoader.class.getName());
    private final DocumentTools documentTools;
    private final BundleEntityLoaderRegistry entityLoaderRegistry;
    private final JsonFileUtils jsonFileUtils;

    @Inject
    EntityBundleLoader(DocumentTools documentTools, BundleEntityLoaderRegistry entityLoaderRegistry, JsonFileUtils jsonFileUtils) {
        this.documentTools = documentTools;
        this.entityLoaderRegistry = entityLoaderRegistry;
        this.jsonFileUtils = jsonFileUtils;
    }

    public Bundle load(List<File> fileSet, BundleLoadingOperation loadingMode, String ... entityTypes) {
        Bundle bundle = new Bundle();
        fileSet.forEach(f -> this.loadBundleFile((File)f, bundle, loadingMode, entityTypes));
        return bundle;
    }

    public Bundle load(File dependencyBundlePath, BundleLoadingOperation loadingMode, String ... entityTypes) {
        Bundle bundle = new Bundle();
        this.loadBundleFile(dependencyBundlePath, bundle, loadingMode, entityTypes);
        return bundle;
    }

    public Bundle loadMetadata(File dependencyMetadataPath, BundleLoadingOperation loadingMode) {
        Bundle bundle = new Bundle();
        bundle.setLoadingMode(loadingMode);
        BundleDefinedEntities bundleDefinedEntities = this.jsonFileUtils.readBundleMetadataFile(dependencyMetadataPath);
        Collection<DefaultMetadata> metadataCollection = bundleDefinedEntities.getDefinedEntities();
        if (metadataCollection != null) {
            metadataCollection.forEach(metadata -> {
                if ("ENCAPSULATED_ASSERTION".equals(metadata.getType())) {
                    Encass encass = this.getEncassFromMetadata((Metadata)metadata);
                    Map<String, Encass> encassMap = bundle.getEncasses();
                    encassMap.put(encass.getName(), encass);
                } else if ("POLICY".equals(metadata.getType())) {
                    Policy policy = EntityBundleLoader.getPolicyFromMetadata(metadata);
                    Map<String, Policy> policyMap = bundle.getPolicies();
                    policyMap.put(metadata.getName(), policy);
                }
            });
        }
        return bundle;
    }

    private static Policy getPolicyFromMetadata(Metadata metadata) {
        Policy policy = new Policy();
        policy.setName(metadata.getName());
        policy.setId(metadata.getId());
        policy.setGuid(metadata.getGuid());
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        annotations.add(AnnotableEntity.SHARED_ANNOTATION);
        policy.setAnnotations(annotations);
        return policy;
    }

    private Encass getEncassFromMetadata(Metadata metadata) {
        Encass encass = new Encass();
        encass.setUniqueEntityName(metadata.getName());
        encass.setName(PathUtils.extractNameFromUniqueEntityName(metadata.getName()));
        encass.setId(metadata.getId());
        encass.setGuid(metadata.getGuid());
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        annotations.add(AnnotableEntity.SHARED_ANNOTATION);
        encass.setAnnotations(annotations);
        return encass;
    }

    private void loadBundleFile(File dependencyBundlePath, Bundle bundle, BundleLoadingOperation loadingMode, String ... entityTypes) {
        Document bundleDocument;
        bundle.setLoadingMode(loadingMode);
        try {
            bundleDocument = this.documentTools.parse(dependencyBundlePath);
        }
        catch (DocumentParseException e) {
            throw new BundleLoadException("Could not parse dependency bundle '" + dependencyBundlePath + "': " + e.getMessage(), e);
        }
        NodeList nodeList = bundleDocument.getElementsByTagName("l7:Item");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.handleItem(bundle, (Element)node, entityTypes);
        }
    }

    private void handleItem(Bundle bundle, Element element, String[] entityTypes) {
        String type = DocumentUtils.getSingleChildElement(element, "l7:Type").getTextContent();
        if (ArrayUtils.isNotEmpty((Object[])entityTypes) && !ArrayUtils.contains((Object[])entityTypes, (Object)type)) {
            return;
        }
        BundleEntityLoader entityLoader = this.entityLoaderRegistry.getLoader(type);
        if (entityLoader != null) {
            entityLoader.load(bundle, element);
        } else {
            LOGGER.log(Level.FINE, "No entity loader found for entity type: {0}", type);
        }
    }
}

