/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.EncassArgument;
import com.ca.apim.gateway.cagatewayconfig.beans.EncassResult;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadingOperation;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Singleton
public class EncassLoader
implements BundleEntityLoader {
    @Override
    public void load(Bundle bundle, Element element) {
        Element encassElement = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:EncapsulatedAssertion");
        String policyId = DocumentUtils.getSingleChildElementAttribute(encassElement, "l7:PolicyReference", "id");
        String name = DocumentUtils.getSingleChildElementTextContent(encassElement, "l7:Name");
        String guid = DocumentUtils.getSingleChildElementTextContent(encassElement, "l7:Guid");
        Map<String, Object> properties = BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(encassElement, "l7:Properties", true), "l7:Properties");
        properties.remove("policyGuid");
        Encass encass = new Encass();
        encass.setGuid(guid);
        encass.setName(name);
        encass.setProperties(properties);
        String policyPath = this.getPath(bundle, policyId);
        encass.setId(encassElement.getAttribute("id"));
        encass.setPolicy(policyPath);
        encass.setArguments(this.getArguments(encassElement));
        encass.setResults(this.getResults(encassElement));
        encass.setPolicyId(policyId);
        bundle.getEncasses().put(name, encass);
    }

    private String getPath(Bundle bundle, String policyId) {
        List policyList = bundle.getPolicies().values().stream().filter(p -> policyId.equals(p.getId())).collect(Collectors.toList());
        if ((policyList.isEmpty() || policyList.size() > 1) && bundle.getLoadingMode() == BundleLoadingOperation.VALIDATE) {
            return null;
        }
        if (policyList.isEmpty()) {
            throw new BundleLoadException("Invalid dependency bundle. Could not find policy with id: " + policyId);
        }
        if (policyList.size() > 1) {
            throw new BundleLoadException("Invalid dependency bundle. Found multiple policies with id: " + policyId);
        }
        return ((Policy)policyList.get(0)).getPath();
    }

    private Set<EncassResult> getResults(Element encass) {
        Element encapsulatedResultsElement = DocumentUtils.getSingleChildElement(encass, "l7:EncapsulatedResults");
        NodeList encapsulatedAssertionResultElement = encapsulatedResultsElement.getElementsByTagName("l7:EncapsulatedAssertionResult");
        LinkedHashSet<EncassResult> encassResults = new LinkedHashSet<EncassResult>(encapsulatedAssertionResultElement.getLength());
        for (Node node : DocumentUtils.nodeList(encapsulatedAssertionResultElement)) {
            if (!(node instanceof Element)) {
                throw new BundleLoadException("Unexpected encass results node: " + encapsulatedResultsElement.getClass());
            }
            Element encassResultElement = (Element)node;
            String resultName = DocumentUtils.getSingleChildElementTextContent(encassResultElement, "l7:ResultName");
            String resultType = DocumentUtils.getSingleChildElementTextContent(encassResultElement, "l7:ResultType");
            encassResults.add(new EncassResult(resultName, resultType));
        }
        return encassResults;
    }

    private Set<EncassArgument> getArguments(Element encass) {
        Element encapsulatedArgumentsElement = DocumentUtils.getSingleChildElement(encass, "l7:EncapsulatedArguments");
        NodeList encapsulatedAssertionArgumentElement = encapsulatedArgumentsElement.getElementsByTagName("l7:EncapsulatedAssertionArgument");
        LinkedHashSet<EncassArgument> encassArguments = new LinkedHashSet<EncassArgument>(encapsulatedAssertionArgumentElement.getLength());
        for (Node node : DocumentUtils.nodeList(encapsulatedAssertionArgumentElement)) {
            if (!(node instanceof Element)) {
                throw new BundleLoadException("Unexpected encass argument node: " + encapsulatedArgumentsElement.getClass());
            }
            Element encassArgElement = (Element)node;
            String argumentName = DocumentUtils.getSingleChildElementTextContent(encassArgElement, "l7:ArgumentName");
            String argumentType = DocumentUtils.getSingleChildElementTextContent(encassArgElement, "l7:ArgumentType");
            Boolean guiPrompt = Boolean.parseBoolean(DocumentUtils.getSingleChildElementTextContent(encassArgElement, "l7:GuiPrompt"));
            String guiLabel = DocumentUtils.getSingleChildElementTextContent(encassArgElement, "l7:GuiLabel");
            encassArguments.add(new EncassArgument(argumentName, argumentType, guiPrompt, guiLabel));
        }
        return encassArguments;
    }

    @Override
    public String getEntityType() {
        return "ENCAPSULATED_ASSERTION";
    }
}

