/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.CassandraConnection;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.Arrays;
import java.util.HashSet;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

@Singleton
public class CassandraConnectionsLoader
implements BundleEntityLoader {
    @Override
    public void load(Bundle bundle, Element element) {
        String ciphersAsString;
        Element cassandraConnectionElement = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:CassandraConnection");
        String name = DocumentUtils.getSingleChildElementTextContent(cassandraConnectionElement, "l7:Name");
        CassandraConnection cassandraConnection = new CassandraConnection();
        cassandraConnection.setName(name);
        cassandraConnection.setId(cassandraConnectionElement.getAttribute("id"));
        cassandraConnection.setKeyspace(DocumentUtils.getSingleChildElementTextContent(cassandraConnectionElement, "l7:Keyspace"));
        cassandraConnection.setCompression(DocumentUtils.getSingleChildElementTextContent(cassandraConnectionElement, "l7:Compression"));
        cassandraConnection.setContactPoint(DocumentUtils.getSingleChildElementTextContent(cassandraConnectionElement, "l7:ContactPoint"));
        cassandraConnection.setPort(Integer.parseInt(DocumentUtils.getSingleChildElementTextContent(cassandraConnectionElement, "l7:Port")));
        cassandraConnection.setProperties(BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(cassandraConnectionElement, "l7:Properties", true), "l7:Properties"));
        cassandraConnection.setSsl(Boolean.parseBoolean(DocumentUtils.getSingleChildElementTextContent(cassandraConnectionElement, "l7:Ssl")));
        cassandraConnection.setUsername(DocumentUtils.getSingleChildElementTextContent(cassandraConnectionElement, "l7:Username"));
        Element passwordIdElement = DocumentUtils.getSingleChildElement(cassandraConnectionElement, "l7:PasswordId", true);
        cassandraConnection.setPasswordId(passwordIdElement != null ? passwordIdElement.getTextContent() : null);
        HashSet<String> ciphers = null;
        Element tlsCiphersElement = DocumentUtils.getSingleChildElement(cassandraConnectionElement, "l7:TlsCiphers", true);
        String string = ciphersAsString = tlsCiphersElement != null ? tlsCiphersElement.getTextContent() : null;
        if (StringUtils.isNotEmpty((CharSequence)ciphersAsString)) {
            ciphers = new HashSet<String>(Arrays.asList(ciphersAsString.split(",")));
        }
        cassandraConnection.setTlsCiphers(ciphers);
        cassandraConnection.setProperties(BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(cassandraConnectionElement, "l7:Properties", true), "l7:Properties"));
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        Annotation bundleEntity = new Annotation("@bundle-hints");
        bundleEntity.setId(cassandraConnectionElement.getAttribute("id"));
        annotations.add(bundleEntity);
        cassandraConnection.setAnnotations(annotations);
        bundle.getCassandraConnections().put(name, cassandraConnection);
    }

    @Override
    public String getEntityType() {
        return "CASSANDRA_CONFIGURATION";
    }
}

