/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.UnsupportedGatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class UnsupportedEntityBuilder
implements EntityBuilder {
    private static final Integer ORDER = Integer.MAX_VALUE;

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        ArrayList<Entity> unsupportedEntities = new ArrayList<Entity>();
        Map<String, UnsupportedGatewayEntity> unsupportedGatewayEntityMap = bundle.getUnsupportedEntities();
        unsupportedGatewayEntityMap.forEach((key, value) -> {
            if (bundleType != EntityBuilder.BundleType.ENVIRONMENT || value.isExcluded()) {
                unsupportedEntities.add(EntityBuilderHelper.getEntityWithOnlyMapping(value.getType(), value.getName(), value.getId()));
            } else {
                Element resourceElement = (Element)document.adoptNode(value.getElement());
                unsupportedEntities.add(EntityBuilderHelper.getEntityWithNameMapping(value.getType(), value.getName(), value.getId(), resourceElement));
            }
        });
        return unsupportedEntities;
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }
}

