/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.PrivateKey;
import com.ca.apim.gateway.cagatewayconfig.beans.Service;
import com.ca.apim.gateway.cagatewayconfig.beans.SsgActiveConnector;
import com.ca.apim.gateway.cagatewayconfig.beans.StoredPassword;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.environment.EnvironmentBundleUtils;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SsgActiveConnectorEntityBuilder
implements EntityBuilder {
    private static final Integer ORDER = 1600;
    private final IdGenerator idGenerator;

    @Inject
    SsgActiveConnectorEntityBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundle instanceof AnnotatedBundle) {
            Map<String, SsgActiveConnector> activeConnectorMap = Optional.ofNullable(bundle.getSsgActiveConnectors()).orElse(Collections.emptyMap());
            return this.buildEntities(activeConnectorMap, ((AnnotatedBundle)bundle).getFullBundle(), bundleType, document);
        }
        return this.buildEntities(bundle.getSsgActiveConnectors(), bundle, bundleType, document);
    }

    private List<Entity> buildEntities(Map<String, SsgActiveConnector> entities, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        switch (bundleType) {
            case DEPLOYMENT: {
                Stream<Entity> activeConnectorOnlyMappings = entities.entrySet().stream().map(ssgActiveConnectorEntry -> EntityBuilderHelper.getEntityWithOnlyMapping("SSG_ACTIVE_CONNECTOR", bundle.applyUniqueName((String)ssgActiveConnectorEntry.getKey(), EntityBuilder.BundleType.ENVIRONMENT), this.generateId((SsgActiveConnector)ssgActiveConnectorEntry.getValue())));
                return activeConnectorOnlyMappings.collect(Collectors.toList());
            }
            case ENVIRONMENT: {
                Stream<Entity> activeConnectors = entities.entrySet().stream().map(ssgActiveConnectorEntry -> this.buildActiveConnectorEntity(bundle, bundle.applyUniqueName((String)ssgActiveConnectorEntry.getKey(), EntityBuilder.BundleType.ENVIRONMENT), (SsgActiveConnector)ssgActiveConnectorEntry.getValue(), document));
                return activeConnectors.collect(Collectors.toList());
            }
        }
        throw new EntityBuilderException("Unknown bundle type: " + (Object)((Object)bundleType));
    }

    Entity buildActiveConnectorEntity(Bundle bundle, String name, SsgActiveConnector ssgActiveConnector, Document document) {
        Element activeConnectorElement = document.createElement("l7:ActiveConnector");
        String id = this.generateId(ssgActiveConnector);
        activeConnectorElement.setAttribute("id", id);
        activeConnectorElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Name", name));
        activeConnectorElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Enabled", Boolean.TRUE.toString()));
        activeConnectorElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Type", ssgActiveConnector.getConnectorType()));
        if (ssgActiveConnector.getTargetServiceReference() != null) {
            activeConnectorElement.appendChild(this.createServiceElement(bundle, name, ssgActiveConnector, document));
        }
        this.updatePasswordRef(bundle, ssgActiveConnector);
        this.updatePrivateKeyRef(bundle, ssgActiveConnector);
        BuilderUtils.buildAndAppendPropertiesElement(ssgActiveConnector.getProperties(), document, activeConnectorElement);
        return EntityBuilderHelper.getEntityWithNameMapping("SSG_ACTIVE_CONNECTOR", name, id, activeConnectorElement);
    }

    private String generateId(SsgActiveConnector ssgActiveConnector) {
        if (ssgActiveConnector != null && ssgActiveConnector.getAnnotatedEntity() != null && ssgActiveConnector.getAnnotatedEntity().getId() != null) {
            return ssgActiveConnector.getAnnotatedEntity().getId();
        }
        return this.idGenerator.generate();
    }

    private void updatePasswordRef(Bundle bundle, SsgActiveConnector entity) {
        entity.getProperties().entrySet().stream().forEach(entry -> {
            if (((String)entry.getKey()).endsWith("SecurePasswordOid")) {
                String value = (String)entry.getValue();
                if (value == null || value.isEmpty()) {
                    return;
                }
                StoredPassword storedPassword = bundle.getEntities(StoredPassword.class).values().stream().filter(s -> s.getKey().equals(value)).findFirst().orElse(null);
                if (storedPassword == null) {
                    throw new EntityBuilderException("Could not find password for Active Connector: " + entity.getName() + ". Password Reference: " + value);
                }
                entry.setValue(storedPassword.getId());
            }
        });
    }

    private void updatePrivateKeyRef(Bundle bundle, SsgActiveConnector entity) {
        AtomicReference privateKeyRef = new AtomicReference();
        AtomicReference key = new AtomicReference();
        entity.getProperties().entrySet().stream().forEach(entry -> {
            if (((String)entry.getKey()).endsWith("SslKeystoreAlias")) {
                String value = (String)entry.getValue();
                if (value == null || value.isEmpty()) {
                    return;
                }
                PrivateKey privateKey = bundle.getEntities(PrivateKey.class).values().stream().filter(s -> s.getAlias().equals(value)).findFirst().orElse(null);
                if (privateKey == null) {
                    throw new EntityBuilderException("Could not find private key for Active Connector: " + entity.getName() + ". Private Key Reference: " + value);
                }
                String[] id = privateKey.getId().split(":");
                privateKeyRef.set(id[0]);
                key.set(((String)entry.getKey()).replace("SslKeystoreAlias", "SslKeystoreId"));
            }
        });
        entity.getProperties().put((String)key.get(), privateKeyRef.get());
    }

    private Element createServiceElement(Bundle bundle, String name, SsgActiveConnector ssgActiveConnector, Document document) {
        String targetServiceReference = ssgActiveConnector.getTargetServiceReference();
        Service service = bundle.getServices().get(targetServiceReference);
        if (service == null || service.getId() == null) {
            service = EnvironmentBundleUtils.getDeploymentBundle().getServices().get(targetServiceReference);
        }
        if (service == null) {
            throw new EntityBuilderException("Could not find service binded to active connector " + name + ". Service Path: " + targetServiceReference);
        }
        return DocumentUtils.createElementWithTextContent(document, "l7:HardwiredId", service.getId());
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }
}

