/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.beans.Service;
import com.ca.apim.gateway.cagatewayconfig.beans.SoapResource;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import com.ca.apim.gateway.cagatewayconfig.util.string.CharacterBlacklistUtil;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class ServiceEntityBuilder
implements EntityBuilder {
    private static final Integer ORDER = 400;
    private final IdGenerator idGenerator;
    private final DocumentTools documentTools;

    @Inject
    ServiceEntityBuilder(DocumentTools documentTools, IdGenerator idGenerator) {
        this.documentTools = documentTools;
        this.idGenerator = idGenerator;
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        return this.buildEntities(bundle.getServices(), bundle, bundleType, document);
    }

    private List<Entity> buildEntities(Map<String, ?> entities, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundleType == EntityBuilder.BundleType.ENVIRONMENT) {
            return Collections.emptyList();
        }
        return entities.entrySet().stream().map(serviceEntry -> this.buildServiceEntity(bundle, (Service)serviceEntry.getValue(), document)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }

    private Entity buildServiceEntity(Bundle bundle, Service service, Document document) {
        AnnotatedEntity<? extends GatewayEntity> annotatedEntity = bundle instanceof AnnotatedBundle ? ((AnnotatedBundle)bundle).getAnnotatedEntity() : null;
        String serviceOriginalPath = service.getName();
        String servicePathWithTargetFolder = EntityBuilderHelper.getPath(service.getParentFolder(), PathUtils.extractName(service.getName()));
        servicePathWithTargetFolder = CharacterBlacklistUtil.decodePath(servicePathWithTargetFolder);
        String baseName = PathUtils.extractName(servicePathWithTargetFolder);
        String basePath = PathUtils.extractPath(servicePathWithTargetFolder);
        String uniqueName = baseName;
        String uniqueServicePath = servicePathWithTargetFolder;
        boolean isRedeployableBundle = false;
        if (annotatedEntity != null) {
            isRedeployableBundle = annotatedEntity.isRedeployable();
            uniqueName = bundle.applyUniqueName(baseName, EntityBuilder.BundleType.DEPLOYMENT);
            uniqueServicePath = basePath + uniqueName;
        }
        service.setName(uniqueName);
        Policy policy = bundle.getPolicies().get(service.getPolicy());
        Set<SoapResource> soapResourceBeans = service.getSoapResources();
        if (CollectionUtils.isNotEmpty(soapResourceBeans)) {
            soapResourceBeans.forEach(soapResourceBean -> {
                String path = PathUtils.unixPath(service.getParentFolder().getPath(), baseName, soapResourceBean.getFileName());
                String content = bundle instanceof AnnotatedBundle ? ((AnnotatedBundle)bundle).getFullBundle().getSoapResources().get(path).getContent() : bundle.getSoapResources().get(path).getContent();
                soapResourceBean.setContent(content);
            });
        }
        boolean isSoapService = CollectionUtils.isNotEmpty(soapResourceBeans);
        if (policy == null) {
            throw new EntityBuilderException("Could not find policy for service. Policy Path: " + service.getPolicy());
        }
        if (service.getId() == null) {
            service.setId(this.idGenerator.generate());
        }
        String id = service.getId();
        Element serviceDetailElement = DocumentUtils.createElementWithAttributes(document, "l7:ServiceDetail", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)id, (Object)"folderId", (Object)service.getParentFolder().getId()));
        serviceDetailElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Name", uniqueName));
        serviceDetailElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Enabled", Boolean.TRUE.toString()));
        serviceDetailElement.appendChild(this.buildServiceMappings(service, document));
        HashMap<String, Object> properties = null;
        if (service.getProperties() != null) {
            properties = service.getProperties().entrySet().stream().collect(Collectors.toMap(p -> "property." + (String)p.getKey(), p -> ((String)p.getKey()).startsWith("ENV.") ? "SERVICE_PROPERTY_" + BuilderUtils.insertPrefixToEnvironmentVariable((String)p.getKey(), service.getName()) : p.getValue()));
        }
        if (properties == null) {
            properties = new HashMap<String, Boolean>();
        }
        properties.put("wssProcessingEnabled", false);
        if (isSoapService) {
            properties.put("soap", true);
            properties.put("soapVersion", service.getSoapVersion());
            properties.put("wssProcessingEnabled", service.isWssProcessingEnabled());
        }
        BuilderUtils.buildAndAppendPropertiesElement(properties, document, serviceDetailElement);
        Element serviceElement = DocumentUtils.createElementWithAttribute(document, "l7:Service", "id", id);
        serviceElement.appendChild(serviceDetailElement);
        Element resourcesElement = document.createElement("l7:Resources");
        Element policyResourceSetElement = DocumentUtils.createElementWithAttribute(document, "l7:ResourceSet", "tag", "policy");
        Element policyResourceElement = DocumentUtils.createElementWithAttribute(document, "l7:Resource", "type", "policy");
        policyResourceElement.setTextContent(this.documentTools.elementToString(policy.getPolicyDocument()));
        policyResourceSetElement.appendChild(policyResourceElement);
        resourcesElement.appendChild(policyResourceSetElement);
        if (isSoapService) {
            Element wsdlResourceSetElement = DocumentUtils.createElementWithAttributes(document, "l7:ResourceSet", (Map<String, String>)ImmutableMap.of((Object)"tag", (Object)"wsdl", (Object)"rootUrl", (Object)service.getWsdlRootUrl()));
            soapResourceBeans.forEach(soapResourceBean -> {
                Element resourceElement = DocumentUtils.createElementWithAttributes(document, "l7:Resource", (Map<String, String>)ImmutableMap.of((Object)"type", (Object)soapResourceBean.getType(), (Object)"sourceUrl", (Object)soapResourceBean.getRootUrl()));
                resourceElement.setTextContent(soapResourceBean.getContent());
                wsdlResourceSetElement.appendChild(resourceElement);
            });
            resourcesElement.appendChild(wsdlResourceSetElement);
        }
        serviceElement.appendChild(resourcesElement);
        Entity entity = EntityBuilderHelper.getEntityWithPathMapping("SERVICE", serviceOriginalPath, uniqueServicePath, id, serviceElement, policy.isHasRouting(), service);
        if (isRedeployableBundle) {
            entity.setMappingAction("NewOrUpdate");
        } else {
            entity.setMappingAction(EntityBuilderHelper.getDefaultEntityMappingAction());
        }
        return entity;
    }

    private Element buildServiceMappings(Service service, Document document) {
        Element serviceMappingsElement = document.createElement("l7:ServiceMappings");
        Element httpMappingElement = document.createElement("l7:HttpMapping");
        serviceMappingsElement.appendChild(httpMappingElement);
        if (service.getUrl() != null) {
            httpMappingElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:UrlPattern", service.getUrl()));
        }
        Element verbsElement = document.createElement("l7:Verbs");
        service.getHttpMethods().forEach(method -> {
            Element verb = document.createElement("l7:Verb");
            verb.setTextContent((String)method);
            verbsElement.appendChild(verb);
        });
        httpMappingElement.appendChild(verbsElement);
        return serviceMappingsElement;
    }
}

