/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.PrivateKey;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Singleton;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class PrivateKeyImportContextBuilder {
    public Element build(PrivateKey privateKey, Document document) {
        if (privateKey != null && privateKey.getPrivateKeyFile() != null) {
            try {
                String pkcs12Data = Base64.encodeBase64String((byte[])IOUtils.toByteArray((InputStream)privateKey.getPrivateKeyFile().getWithIO()));
                Element privateKeyImportContext = DocumentUtils.createElementWithChildren(document, "l7:PrivateKeyImportContext", DocumentUtils.createElementWithTextContent(document, "l7:Pkcs12Data", pkcs12Data), DocumentUtils.createElementWithTextContent(document, "l7:Alias", privateKey.getAlias()), DocumentUtils.createElementWithTextContent(document, "l7:Password", privateKey.getKeyPassword()));
                privateKeyImportContext.setAttribute("xmlns:l7", "http://ns.l7tech.com/2010/04/gateway-management");
                return privateKeyImportContext;
            }
            catch (IOException e) {
                throw new EntityBuilderException("Couldn't load private key file: " + privateKey.getAlias());
            }
        }
        return null;
    }
}

