/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.PrivateKey;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyEntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.CertificateUtils;
import com.ca.apim.gateway.cagatewayconfig.util.keystore.KeystoreHelper;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class PrivateKeyEntityBuilder
implements EntityBuilder {
    private static final Logger LOGGER = Logger.getLogger(PolicyEntityBuilder.class.getName());
    private static final Integer ORDER = 800;
    private static final String DUMMY_CERTIFICATE = "MIIBfTCCASegAwIBAgIJAPH69zKKw4ixMA0GCSqGSIb3DQEBBQUAMA8xDTALBgNVBAMTBHRlc3QwHhcNMTgxMDEzMDMyODI1WhcNMzgxMDA4MDMyODI1WjAPMQ0wCwYDVQQDEwR0ZXN0MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAIS+Vr8zPOBmSclkUtW/z0UXaMjhg7dix6IUZs+UoSiw/2GXfU2vc3renVAbn3AZaJEqnxgrcX4nldqt0WBIP4sCAwEAAaNmMGQwDgYDVR0PAQH/BAQDAgXgMBIGA1UdJQEB/wQIMAYGBFUdJQAwHQYDVR0OBBYEFN/aeDDEAB6MTxZhMhf/eJKnmaE5MB8GA1UdIwQYMBaAFN/aeDDEAB6MTxZhMhf/eJKnmaE5MA0GCSqGSIb3DQEBBQUAA0EAdolvh7bMX5ZMkM/yntJlBdzS8ukM/ULh8I11wKd6dDltyMuk9rOP0iEk1nsSFuFL0uQ4kIe12KyDwr8ns7VKvQ==";
    private final KeystoreHelper keystoreHelper;

    @Inject
    PrivateKeyEntityBuilder(KeystoreHelper keystoreHelper) {
        this.keystoreHelper = keystoreHelper;
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        Map privateKeyMap = Optional.ofNullable(bundle.getPrivateKeys()).orElse(Collections.emptyMap());
        return this.buildEntities(bundle, bundleType, privateKeyMap, document);
    }

    private List<Entity> buildEntities(Bundle bundle, EntityBuilder.BundleType bundleType, Map<String, ?> entities, Document document) {
        switch (bundleType) {
            case DEPLOYMENT: {
                return entities.entrySet().stream().map(e -> EntityBuilderHelper.getEntityWithOnlyMapping("SSG_KEY_ENTRY", (String)e.getKey(), this.generatePrivateKeyId((PrivateKey)e.getValue()))).collect(Collectors.toList());
            }
            case ENVIRONMENT: {
                return entities.entrySet().stream().map(e -> this.buildPrivateKeyEntity(bundle, (String)e.getKey(), (PrivateKey)e.getValue(), document)).collect(Collectors.toList());
            }
        }
        throw new EntityBuilderException("Unknown bundle type: " + (Object)((Object)bundleType));
    }

    private Entity buildPrivateKeyEntity(Bundle bundle, String alias, PrivateKey privateKey, Document document) {
        privateKey.setId(this.generatePrivateKeyId(privateKey));
        if (privateKey.getPrivateKeyFile() == null) {
            privateKey.setPrivateKeyFile(bundle.getPrivateKeyFiles().get(alias));
        }
        Element privateKeyElem = DocumentUtils.createElementWithAttributes(document, "l7:PrivateKey", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)privateKey.getId(), (Object)"keystoreId", (Object)privateKey.getKeyStoreType().getId(), (Object)"alias", (Object)alias));
        this.buildAndAppendCertificateChainElement(privateKey, privateKeyElem, document);
        BuilderUtils.buildAndAppendPropertiesElement((Map<String, Object>)ImmutableMap.of((Object)"keyAlgorithm", (Object)privateKey.getAlgorithm()), document, privateKeyElem);
        Entity entity = EntityBuilderHelper.getEntityWithNameMapping("SSG_KEY_ENTRY", alias, privateKey.getId(), privateKeyElem);
        entity.setMappingAction("NewOrExisting");
        entity.setMappingProperty("FailOnNew", true);
        return entity;
    }

    private void buildAndAppendCertificateChainElement(PrivateKey privateKey, Element privateKeyElem, Document document) {
        if (privateKey.getPrivateKeyFile() != null) {
            if (StringUtils.isBlank((CharSequence)privateKey.getKeyPassword())) {
                LOGGER.log(Level.WARNING, "PrivateKey password not provided, attempting with blank password.");
                privateKey.setKeyPassword("");
            }
            KeyStore keyStore = this.keystoreHelper.loadKeyStore(privateKey);
            Certificate[] certificates = this.keystoreHelper.loadCertificatesForPrivateKey(privateKey, keyStore);
            Element[] certificatesElements = (Element[])Stream.of(certificates).map(c -> CertificateUtils.createCertDataElementFromCert((X509Certificate)c, document)).toArray(Element[]::new);
            privateKeyElem.appendChild(DocumentUtils.createElementWithChildren(document, "l7:CertificateChain", certificatesElements));
        } else {
            privateKeyElem.appendChild(DocumentUtils.createElementWithChildren(document, "l7:CertificateChain", CertificateUtils.createCertDataElementFromCert("", BigInteger.valueOf(0L), "", DUMMY_CERTIFICATE, document)));
        }
    }

    private String generatePrivateKeyId(PrivateKey privateKey) {
        return privateKey.getKeyStoreType().generateKeyId(privateKey.getAlias());
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }
}

