/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.Folderable;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.beans.PolicyBackedService;
import com.ca.apim.gateway.cagatewayconfig.beans.PolicyType;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyBuilderContext;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyXMLBuilder;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.IdValidator;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import com.ca.apim.gateway.cagatewayconfig.util.string.CharacterBlacklistUtil;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class PolicyEntityBuilder
implements EntityBuilder {
    private static final Logger LOGGER = Logger.getLogger(PolicyEntityBuilder.class.getName());
    static final String STRING_VALUE = "stringValue";
    private static final String TYPE = "type";
    private static final Integer ORDER = 200;
    public static final String POLICY = "policy";
    public static final String ZERO_GUID = "00000000-0000-0000-0000-000000000000";
    private final DocumentTools documentTools;
    private final IdGenerator idGenerator;
    private final PolicyXMLBuilder policyXMLBuilder;

    @Inject
    PolicyEntityBuilder(DocumentTools documentTools, IdGenerator idGenerator, PolicyXMLBuilder policyXMLBuilder) {
        this.documentTools = documentTools;
        this.idGenerator = idGenerator;
        this.policyXMLBuilder = policyXMLBuilder;
    }

    public List<Entity> buildEntities(Map<String, ?> policyMap, AnnotatedBundle annotatedBundle, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundleType == EntityBuilder.BundleType.ENVIRONMENT) {
            return Collections.emptyList();
        }
        AnnotatedEntity<? extends GatewayEntity> annotatedEntity = annotatedBundle != null ? annotatedBundle.getAnnotatedEntity() : null;
        policyMap.values().forEach(policy -> {
            Policy policyEntity = (Policy)policy;
            if (annotatedEntity != null) {
                AnnotatedEntity annotatedPolicyEntity = policyEntity.getAnnotatedEntity();
                if (policyEntity.isParentEntityShared()) {
                    if (annotatedPolicyEntity != null) {
                        if (annotatedPolicyEntity.getId() != null) {
                            if (IdValidator.isValidGoid(annotatedPolicyEntity.getId())) {
                                policyEntity.setId(annotatedPolicyEntity.getId());
                            } else {
                                LOGGER.log(Level.WARNING, "ignoring given invalid goid {0} for entity {1}", new String[]{annotatedPolicyEntity.getId(), policyEntity.getName()});
                            }
                        }
                        if (annotatedPolicyEntity.getGuid() != null) {
                            if (IdValidator.isValidGuid(annotatedPolicyEntity.getGuid())) {
                                policyEntity.setGuid(annotatedPolicyEntity.getGuid());
                            } else {
                                LOGGER.log(Level.WARNING, "ignoring given invalid guid {0} for entity {1}", new String[]{annotatedPolicyEntity.getId(), policyEntity.getName()});
                            }
                        }
                    }
                } else {
                    policyEntity.setId(this.idGenerator.generate());
                    policyEntity.setGuid(this.idGenerator.generateGuid());
                }
            }
        });
        policyMap.values().forEach(policy -> this.preparePolicy((Policy)policy, bundle, annotatedBundle));
        LinkedList orderedPolicies = new LinkedList();
        policyMap.forEach((path, policy) -> PolicyEntityBuilder.maybeAddPolicy(bundle, (Policy)policy, orderedPolicies, new HashSet<Policy>()));
        return orderedPolicies.stream().map(policy -> this.buildPolicyEntity((Policy)policy, annotatedBundle, bundle, document)).collect(Collectors.toList());
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundle instanceof AnnotatedBundle) {
            AnnotatedBundle annotatedBundle = (AnnotatedBundle)bundle;
            Map map = Optional.ofNullable(bundle.getPolicies()).orElse(Collections.emptyMap());
            return this.buildEntities(map, annotatedBundle, annotatedBundle.getFullBundle(), bundleType, document);
        }
        return this.buildEntities(bundle.getPolicies(), null, bundle, bundleType, document);
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }

    @VisibleForTesting
    static void maybeAddPolicy(Bundle bundle, Policy policy, List<Policy> orderedPolicies, Set<Policy> seenPolicies) {
        if (orderedPolicies.contains(policy) || bundle.getServices().get(FilenameUtils.removeExtension((String)policy.getPath())) != null) {
            return;
        }
        if (seenPolicies.contains(policy)) {
            throw new EntityBuilderException("Detected Policy Include cycle containing policies: " + seenPolicies.stream().map(Folderable::getPath).collect(Collectors.joining(",")));
        }
        seenPolicies.add(policy);
        policy.getDependencies().forEach(dependency -> PolicyEntityBuilder.maybeAddPolicy(bundle, dependency, orderedPolicies, seenPolicies));
        seenPolicies.remove(policy);
        orderedPolicies.add(policy);
    }

    private void preparePolicy(Policy policy, Bundle bundle, AnnotatedBundle annotatedBundle) {
        AnnotatedEntity<? extends GatewayEntity> annotatedEntity;
        Document policyDocument = this.loadPolicyDocument(policy);
        String policyName = policy.getName();
        AnnotatedEntity<? extends GatewayEntity> annotatedEntity2 = annotatedEntity = annotatedBundle != null ? annotatedBundle.getAnnotatedEntity() : null;
        if (annotatedEntity != null) {
            policyName = annotatedBundle.applyUniqueName(policy.getName(), EntityBuilder.BundleType.DEPLOYMENT, policy.isParentEntityShared());
        }
        PolicyBuilderContext policyBuilderContext = new PolicyBuilderContext(policyName, policyDocument, bundle, this.idGenerator);
        policyBuilderContext.withPolicy(policy).withAnnotatedBundle(annotatedBundle);
        this.policyXMLBuilder.buildPolicyXML(policyBuilderContext);
        policy.setPolicyDocument(policyDocument.getDocumentElement());
    }

    private Document loadPolicyDocument(Policy policy) {
        Document policyDocument;
        try {
            policyDocument = DocumentUtils.stringToXMLDocument(this.documentTools, policy.getPolicyXML());
        }
        catch (DocumentParseException e) {
            throw new EntityBuilderException("Could not load policy: " + e.getMessage(), e);
        }
        return policyDocument;
    }

    public static void resolvePossibleMissingEncapsulatedAssertionDependencies(Bundle bundle, Element encapsulatedAssertionElement) {
        Element guidElement = DocumentUtils.getSingleChildElement(encapsulatedAssertionElement, "L7p:EncapsulatedAssertionConfigGuid", true);
        if (guidElement == null) {
            return;
        }
        Element nameElement = DocumentUtils.getSingleChildElement(encapsulatedAssertionElement, "L7p:EncapsulatedAssertionConfigName", true);
        if (nameElement == null) {
            return;
        }
        String guid = guidElement.getAttribute(STRING_VALUE);
        if (!ZERO_GUID.equals(guid)) {
            return;
        }
        String name = nameElement.getAttribute(STRING_VALUE);
        List encasses = bundle.getEncasses().values().stream().filter(e -> name.equals(e.getName())).collect(Collectors.toList());
        if (encasses.isEmpty()) {
            return;
        }
        if (encasses.size() > 1) {
            throw new EntityBuilderException("Found multiple encasses in dependency bundles with name: " + name);
        }
        Encass encass = (Encass)IterableUtils.first(encasses);
        guidElement.setAttribute(STRING_VALUE, encass.getGuid());
    }

    @VisibleForTesting
    Entity buildPolicyEntity(Policy policy, AnnotatedBundle annotatedBundle, Bundle bundle, Document document) {
        String policyName = policy.getName();
        String policyNameWithPath = EntityBuilderHelper.getPath(policy.getParentFolder(), policyName);
        policyNameWithPath = CharacterBlacklistUtil.decodePath(policyNameWithPath);
        AnnotatedEntity<? extends GatewayEntity> annotatedEntity = annotatedBundle != null ? annotatedBundle.getAnnotatedEntity() : null;
        boolean isRedeployableBundle = false;
        if (annotatedEntity != null) {
            isRedeployableBundle = annotatedEntity.isRedeployable();
            policyName = annotatedBundle.applyUniqueName(policyName, EntityBuilder.BundleType.DEPLOYMENT, policy.isParentEntityShared());
            policyNameWithPath = PathUtils.extractPath(policyNameWithPath) + policyName;
        }
        PolicyTags policyTags = this.getPolicyTags(policy, bundle);
        Element policyDetailElement = DocumentUtils.createElementWithAttributesAndChildren(document, "l7:PolicyDetail", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)policy.getId(), (Object)"guid", (Object)policy.getGuid(), (Object)"folderId", (Object)policy.getParentFolder().getId()), DocumentUtils.createElementWithTextContent(document, "l7:Name", policyName), DocumentUtils.createElementWithTextContent(document, "l7:PolicyType", policyTags == null ? PolicyType.INCLUDE.getType() : policyTags.type.getType()));
        if (policyTags != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"tag", (Object)policyTags.tag);
            if (policyTags.subtag != null) {
                builder.put((Object)"subtag", (Object)policyTags.subtag);
            }
            BuilderUtils.buildAndAppendPropertiesElement((Map<String, Object>)builder.build(), document, policyDetailElement);
        }
        Element policyElement = DocumentUtils.createElementWithAttributes(document, "l7:Policy", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)policy.getId(), (Object)"guid", (Object)policy.getGuid()));
        policyElement.appendChild(policyDetailElement);
        Element resourcesElement = document.createElement("l7:Resources");
        Element resourceSetElement = DocumentUtils.createElementWithAttribute(document, "l7:ResourceSet", "tag", POLICY);
        Element resourceElement = DocumentUtils.createElementWithAttribute(document, "l7:Resource", TYPE, POLICY);
        resourceElement.setTextContent(this.documentTools.elementToString(policy.getPolicyDocument()));
        resourceSetElement.appendChild(resourceElement);
        resourcesElement.appendChild(resourceSetElement);
        policyElement.appendChild(resourcesElement);
        Entity entity = EntityBuilderHelper.getEntityWithPathMapping("POLICY", policy.getPath(), policyNameWithPath, policy.getId(), policyElement, policy.isHasRouting(), policy);
        if (isRedeployableBundle) {
            entity.setMappingAction("NewOrUpdate");
        } else if (policy.isParentEntityShared()) {
            entity.setMappingAction("NewOrExisting");
        } else {
            entity.setMappingAction(EntityBuilderHelper.getDefaultEntityMappingAction());
        }
        return entity;
    }

    private PolicyTags getPolicyTags(Policy policy, Bundle bundle) {
        if (Stream.of(PolicyType.GLOBAL, PolicyType.INTERNAL).collect(Collectors.toList()).contains((Object)policy.getPolicyType()) && StringUtils.isNotEmpty((CharSequence)policy.getTag())) {
            return new PolicyTags(policy.getPolicyType(), policy.getTag(), null);
        }
        AtomicReference policyTags = new AtomicReference();
        for (PolicyBackedService pbs : bundle.getPolicyBackedServices().values()) {
            pbs.getOperations().stream().filter(o -> o.getPolicy().equals(policy.getPath())).forEach(o -> {
                if (!policyTags.compareAndSet(null, new PolicyTags(PolicyType.SERVICE_OPERATION, pbs.getInterfaceName(), o.getOperationName()))) {
                    throw new EntityBuilderException("Found multiple policy backed service operations for policy: " + policy.getPath());
                }
            });
        }
        return (PolicyTags)policyTags.get();
    }

    private class PolicyTags {
        private final PolicyType type;
        private final String tag;
        private final String subtag;

        private PolicyTags(PolicyType type, String tag, String subtag) {
            this.type = type;
            this.tag = tag;
            this.subtag = subtag;
        }
    }
}

