/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.beans.PolicyBackedService;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class PolicyBackedServiceEntityBuilder
implements EntityBuilder {
    private static final Integer ORDER = 600;
    private final IdGenerator idGenerator;

    @Inject
    PolicyBackedServiceEntityBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundle instanceof AnnotatedBundle) {
            Map policyBackedServiceMap = Optional.ofNullable(bundle.getPolicyBackedServices()).orElse(Collections.emptyMap());
            return this.buildEntities(policyBackedServiceMap, ((AnnotatedBundle)bundle).getFullBundle(), bundleType, document);
        }
        return this.buildEntities(bundle.getPolicyBackedServices(), bundle, bundleType, document);
    }

    private List<Entity> buildEntities(Map<String, ?> entities, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundleType == EntityBuilder.BundleType.ENVIRONMENT) {
            return Collections.emptyList();
        }
        return entities.entrySet().stream().map(pbsEntry -> this.buildPBSEntity(bundle, (String)pbsEntry.getKey(), (PolicyBackedService)pbsEntry.getValue(), document)).collect(Collectors.toList());
    }

    private Entity buildPBSEntity(Bundle bundle, String name, PolicyBackedService policyBackedService, Document document) {
        String id = this.idGenerator.generate();
        Element policyBackedServiceElement = DocumentUtils.createElementWithAttributesAndChildren(document, "l7:PolicyBackedService", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)id), DocumentUtils.createElementWithTextContent(document, "l7:Name", name), DocumentUtils.createElementWithTextContent(document, "l7:InterfaceName", policyBackedService.getInterfaceName()), this.buildOperations(policyBackedService, bundle, document));
        return EntityBuilderHelper.getEntityWithNameMapping("POLICY_BACKED_SERVICE", name, id, policyBackedServiceElement);
    }

    private Element buildOperations(PolicyBackedService policyBackedService, Bundle bundle, Document document) {
        Element policyBackedServiceOperationsElement = document.createElement("l7:PolicyBackedServiceOperations");
        if (policyBackedService.getOperations() != null) {
            policyBackedService.getOperations().forEach(operation -> {
                Policy policy = bundle.getPolicies().get(operation.getPolicy());
                if (policy == null) {
                    throw new EntityBuilderException("Could not find policy for policy backed service. Policy Path: " + operation.getPolicy());
                }
                policyBackedServiceOperationsElement.appendChild(DocumentUtils.createElementWithChildren(document, "l7:PolicyBackedServiceOperation", DocumentUtils.createElementWithTextContent(document, "l7:PolicyId", policy.getId()), DocumentUtils.createElementWithTextContent(document, "l7:OperationName", operation.getOperationName())));
            });
        }
        return policyBackedServiceOperationsElement;
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }
}

