/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.JmsDestination;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyAssertionBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyBuilderContext;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import org.w3c.dom.Element;

public class JmsAssertionBuilder
implements PolicyAssertionBuilder {
    @Override
    public void buildAssertionElement(Element assertionElement, PolicyBuilderContext policyBuilderContext) {
        Bundle bundle = policyBuilderContext.getBundle();
        IdGenerator idGenerator = policyBuilderContext.getIdGenerator();
        Element connectionNameElement = DocumentUtils.getSingleChildElement(assertionElement, "L7p:EndpointName", true);
        if (connectionNameElement != null) {
            String connectionName = connectionNameElement.getAttributes().getNamedItem("stringValue").getTextContent();
            connectionNameElement.setAttribute("stringValue", bundle.applyUniqueName(connectionName, EntityBuilder.BundleType.ENVIRONMENT));
            JmsDestination jmsDestination = bundle.getJmsDestinations().get(connectionName);
            String id = jmsDestination != null ? (jmsDestination.getAnnotatedEntity() != null && jmsDestination.getAnnotatedEntity().getId() != null ? jmsDestination.getAnnotatedEntity().getId() : jmsDestination.getId()) : idGenerator.generate();
            Element jmdDestinationGoidElement = DocumentUtils.createElementWithAttribute(policyBuilderContext.getPolicyDocument(), "L7p:EndpointOid", "goidValue", id);
            assertionElement.insertBefore(jmdDestinationGoidElement, connectionNameElement);
        }
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:JmsRoutingAssertion";
    }
}

