/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.JdbcConnection;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class JdbcConnectionEntityBuilder
implements EntityBuilder {
    private static final Integer ORDER = 1000;
    private final IdGenerator idGenerator;

    @Inject
    JdbcConnectionEntityBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        Map jdbcConnectionMap = Optional.ofNullable(bundle.getJdbcConnections()).orElse(Collections.emptyMap());
        return this.buildEntities(jdbcConnectionMap, bundle, bundleType, document);
    }

    private List<Entity> buildEntities(Map<String, ?> entities, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        switch (bundleType) {
            case DEPLOYMENT: {
                return entities.entrySet().stream().map(e -> EntityBuilderHelper.getEntityWithOnlyMapping("JDBC_CONNECTION", bundle.applyUniqueName((String)e.getKey(), EntityBuilder.BundleType.ENVIRONMENT), this.generateId((JdbcConnection)e.getValue()))).collect(Collectors.toList());
            }
            case ENVIRONMENT: {
                return entities.entrySet().stream().map(e -> this.buildEntity(bundle.applyUniqueName((String)e.getKey(), bundleType), (JdbcConnection)e.getValue(), document)).collect(Collectors.toList());
            }
        }
        throw new EntityBuilderException("Unknown bundle type: " + (Object)((Object)bundleType));
    }

    @VisibleForTesting
    Entity buildEntity(String name, JdbcConnection jdbc, Document document) {
        String id = this.generateId(jdbc);
        Element jdbcElement = DocumentUtils.createElementWithAttributesAndChildren(document, "l7:JDBCConnection", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)id), DocumentUtils.createElementWithTextContent(document, "l7:Name", name), DocumentUtils.createElementWithTextContent(document, "l7:Enabled", Boolean.TRUE.toString()));
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("minimumPoolSize", jdbc.getMinimumPoolSize());
        properties.put("maximumPoolSize", jdbc.getMaximumPoolSize());
        BuilderUtils.buildAndAppendPropertiesElement(properties, document, jdbcElement);
        Map connectionProperties = Optional.ofNullable(jdbc.getProperties()).orElseGet(HashMap::new);
        connectionProperties.put("user", jdbc.getUser());
        if (jdbc.getPasswordRef() != null) {
            connectionProperties.put("password", String.format("${secpass.%s.plaintext}", jdbc.getPasswordRef()));
        } else {
            connectionProperties.put("password", jdbc.getPassword());
        }
        jdbcElement.appendChild(DocumentUtils.createElementWithChildren(document, "l7:Extension", DocumentUtils.createElementWithTextContent(document, "l7:DriverClass", jdbc.getDriverClass()), DocumentUtils.createElementWithTextContent(document, "l7:JdbcUrl", jdbc.getJdbcUrl()), BuilderUtils.buildPropertiesElement(connectionProperties, document, "l7:ConnectionProperties")));
        return EntityBuilderHelper.getEntityWithNameMapping("JDBC_CONNECTION", name, id, jdbcElement);
    }

    private String generateId(JdbcConnection jdbcConnection) {
        if (jdbcConnection != null && jdbcConnection.getAnnotatedEntity() != null && StringUtils.isNotBlank((CharSequence)jdbcConnection.getAnnotatedEntity().getId())) {
            return jdbcConnection.getAnnotatedEntity().getId();
        }
        return this.idGenerator.generate();
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }
}

