/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.DependentBundle;
import com.ca.apim.gateway.cagatewayconfig.beans.MissingGatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyAssertionBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyBuilderContext;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class IncludeAssertionBuilder
implements PolicyAssertionBuilder {
    private static final Logger LOGGER = Logger.getLogger(IncludeAssertionBuilder.class.getName());
    static final String POLICY_PATH = "policyPath";

    @Override
    public void buildAssertionElement(Element includeAssertionElement, PolicyBuilderContext policyBuilderContext) {
        Element policyGuidElement;
        Bundle bundle = policyBuilderContext.getBundle();
        AnnotatedBundle annotatedBundle = policyBuilderContext.getAnnotatedBundle();
        Policy policy = policyBuilderContext.getPolicy();
        try {
            policyGuidElement = DocumentUtils.getSingleElement(includeAssertionElement, "L7p:PolicyGuid");
        }
        catch (DocumentParseException e) {
            throw new EntityBuilderException("Could not find PolicyGuid element in Include Assertion", e);
        }
        String policyPath = policyGuidElement.getAttribute(POLICY_PATH);
        LOGGER.log(Level.FINE, "Looking for referenced policy include: {0}", policyPath);
        AtomicReference<Policy> includedPolicy = annotatedBundle != null ? new AtomicReference<Policy>(annotatedBundle.getPolicies().get(policyPath)) : new AtomicReference<Policy>(bundle.getPolicies().get(policyPath));
        if (includedPolicy.get() != null) {
            policy.getDependencies().add(includedPolicy.get());
        } else {
            bundle.getDependencies().forEach(b -> {
                Policy policyFromDependencies = Optional.ofNullable(b.getPolicies().get(policyPath)).orElse(b.getPolicies().get(PathUtils.extractName(policyPath)));
                if (policyFromDependencies != null) {
                    if (!includedPolicy.compareAndSet(null, policyFromDependencies)) {
                        throw new EntityBuilderException("Found multiple policies in dependency bundles with policy path: " + policyPath);
                    }
                    DependentBundle dependentBundle = b.getDependentBundleFrom();
                    if (dependentBundle != null && dependentBundle.getType() != null) {
                        if (annotatedBundle != null) {
                            annotatedBundle.addDependentBundle(dependentBundle);
                        } else {
                            bundle.addDependentBundle(dependentBundle);
                        }
                    }
                }
            });
            MissingGatewayEntity missingEntity = bundle.getMissingEntities().get(policyPath);
            if (missingEntity != null && missingEntity.isExcluded()) {
                LOGGER.log(Level.WARNING, "Resolving the referenced policy {0} as known excluded entity with guid: {1}", new Object[]{policyPath, missingEntity.getGuid()});
                includedPolicy.set(new Policy());
                includedPolicy.get().setGuid(missingEntity.getGuid());
            }
        }
        if (includedPolicy.get() == null) {
            throw new EntityBuilderException("Could not find referenced policy include with path: " + policyPath);
        }
        policyGuidElement.setAttribute("stringValue", includedPolicy.get().getGuid());
        policyGuidElement.removeAttribute(POLICY_PATH);
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:Include";
    }
}

