/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.BindOnlyLdapIdentityProviderDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.FederatedIdentityProviderDetail;
import com.ca.apim.gateway.cagatewayconfig.beans.IdentityProvider;
import com.ca.apim.gateway.cagatewayconfig.beans.TrustedCert;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class IdentityProviderEntityBuilder
implements EntityBuilder {
    private static final Logger LOGGER = Logger.getLogger(IdentityProviderEntityBuilder.class.getName());
    private static final Integer ORDER = 1100;
    private static final String TRUSTED_CERT_URI = "http://ns.l7tech.com/2010/04/gateway-management/trustedCertificates";

    IdentityProviderEntityBuilder() {
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundle instanceof AnnotatedBundle) {
            Map identityProviderMap = Optional.ofNullable(bundle.getIdentityProviders()).orElse(Collections.emptyMap());
            return this.buildEntities(identityProviderMap, ((AnnotatedBundle)bundle).getFullBundle(), bundleType, document);
        }
        return this.buildEntities(bundle.getIdentityProviders(), bundle, bundleType, document);
    }

    private List<Entity> buildEntities(Map<String, ?> entities, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        switch (bundleType) {
            case DEPLOYMENT: {
                return entities.entrySet().stream().map(identityProviderEntry -> EntityBuilderHelper.getEntityWithOnlyMapping("ID_PROVIDER_CONFIG", this.generateUniqueName(bundle, (String)identityProviderEntry.getKey(), (IdentityProvider)identityProviderEntry.getValue()), this.generateId((IdentityProvider)identityProviderEntry.getValue()))).collect(Collectors.toList());
            }
            case ENVIRONMENT: {
                return entities.entrySet().stream().map(identityProviderEntry -> this.buildIdentityProviderEntity(bundle, this.generateUniqueName(bundle, (String)identityProviderEntry.getKey(), (IdentityProvider)identityProviderEntry.getValue()), (IdentityProvider)identityProviderEntry.getValue(), document)).collect(Collectors.toList());
            }
        }
        throw new EntityBuilderException("Unknown bundle type: " + (Object)((Object)bundleType));
    }

    private Entity buildIdentityProviderEntity(Bundle bundle, String name, IdentityProvider identityProvider, Document document) {
        String id = this.generateId(identityProvider);
        Element identityProviderElement = DocumentUtils.createElementWithAttribute(document, "l7:IdentityProvider", "id", id);
        identityProviderElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Name", name));
        identityProviderElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:IdentityProviderType", identityProvider.getType().getValue()));
        if (identityProvider.getProperties() != null) {
            BuilderUtils.buildAndAppendPropertiesElement(identityProvider.getProperties(), document, identityProviderElement);
        }
        Entity entity = null;
        switch (identityProvider.getType()) {
            case BIND_ONLY_LDAP: {
                identityProviderElement.appendChild(this.buildBindOnlyLdapIPDetails(identityProvider, document));
                entity = EntityBuilderHelper.getEntityWithNameMapping("ID_PROVIDER_CONFIG", name, id, identityProviderElement);
                break;
            }
            case FEDERATED: {
                FederatedIdentityProviderDetail identityProviderDetail = (FederatedIdentityProviderDetail)identityProvider.getIdentityProviderDetail();
                this.appendFedIdProvDetails(bundle, identityProviderDetail, document, identityProviderElement);
                entity = EntityBuilderHelper.getEntityWithNameMapping("ID_PROVIDER_CONFIG", name, id, identityProviderElement);
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "unsupported identity provider type, please add/migrate the entity {0} to target gateway by other utilities.", name);
                entity = EntityBuilderHelper.getEntityWithOnlyMapping("ID_PROVIDER_CONFIG", name, id);
                entity.setMappingAction("NewOrExisting");
                entity.setMappingProperty("FailOnNew", true);
            }
        }
        return entity;
    }

    private void appendFedIdProvDetails(Bundle bundle, FederatedIdentityProviderDetail identityProviderDetail, Document document, Element identityProviderElement) {
        if (identityProviderDetail == null) {
            return;
        }
        Element extensionElement = document.createElement("l7:Extension");
        Element federatedIdProviderDetailElem = document.createElement("l7:FederatedIdentityProviderDetail");
        extensionElement.appendChild(federatedIdProviderDetailElem);
        Element certReferencesElem = DocumentUtils.createElementWithAttribute(document, "l7:CertificateReferences", "resourceUri", TRUSTED_CERT_URI);
        federatedIdProviderDetailElem.appendChild(certReferencesElem);
        Set<String> certReferences = identityProviderDetail.getCertificateReferences();
        if (CollectionUtils.isEmpty(certReferences)) {
            throw new EntityBuilderException("Certificate References must not be empty.");
        }
        Map<String, TrustedCert> trustedCertMap = bundle.getTrustedCerts();
        certReferences.forEach(certName -> {
            TrustedCert cert = (TrustedCert)trustedCertMap.get(certName);
            if (cert == null) {
                throw new EntityBuilderException("Certificate Reference with name: " + certName + " not found.");
            }
            certReferencesElem.appendChild(DocumentUtils.createElementWithAttribute(document, "l7:Reference", "id", cert.getId()));
        });
        identityProviderElement.appendChild(extensionElement);
    }

    private Element buildBindOnlyLdapIPDetails(IdentityProvider identityProvider, Document document) {
        BindOnlyLdapIdentityProviderDetail identityProviderDetail = (BindOnlyLdapIdentityProviderDetail)identityProvider.getIdentityProviderDetail();
        if (identityProviderDetail == null) {
            throw new EntityBuilderException("Identity Provider Detail must be specified for BIND_ONLY_LDAP");
        }
        Element extensionElement = document.createElement("l7:Extension");
        Element bindOnlyLdapIdentityProviderDetailElement = document.createElement("l7:BindOnlyLdapIdentityProviderDetail");
        extensionElement.appendChild(bindOnlyLdapIdentityProviderDetailElement);
        Element serverUrlsElement = document.createElement("l7:ServerUrls");
        bindOnlyLdapIdentityProviderDetailElement.appendChild(serverUrlsElement);
        Set<String> serverUrls = identityProviderDetail.getServerUrls();
        if (CollectionUtils.isEmpty(serverUrls)) {
            throw new EntityBuilderException("Server Urls must not be empty.");
        }
        serverUrls.forEach(url -> serverUrlsElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:StringValue", url)));
        bindOnlyLdapIdentityProviderDetailElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:UseSslClientAuthentication", String.valueOf(identityProviderDetail.isUseSslClientAuthentication())));
        bindOnlyLdapIdentityProviderDetailElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:BindPatternPrefix", identityProviderDetail.getBindPatternPrefix()));
        bindOnlyLdapIdentityProviderDetailElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:BindPatternSuffix", identityProviderDetail.getBindPatternSuffix()));
        return extensionElement;
    }

    private String generateId(IdentityProvider identityProvider) {
        if (identityProvider != null && identityProvider.getAnnotatedEntity() != null && StringUtils.isNotBlank((CharSequence)identityProvider.getAnnotatedEntity().getId())) {
            return identityProvider.getAnnotatedEntity().getId();
        }
        return identityProvider.getId();
    }

    private String generateUniqueName(Bundle bundle, String name, IdentityProvider identityProvider) {
        if (identityProvider != null && (identityProvider.getType() == IdentityProvider.IdentityProviderType.BIND_ONLY_LDAP || identityProvider.getType() == IdentityProvider.IdentityProviderType.FEDERATED)) {
            return bundle.applyUniqueName(name, EntityBuilder.BundleType.ENVIRONMENT);
        }
        return name;
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }
}

