/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.GenericEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenericEntityBuilder
implements EntityBuilder {
    private static final Integer ORDER = 1700;
    private final IdGenerator idGenerator;

    @Inject
    public GenericEntityBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        Map<String, GenericEntity> genericEntities = Optional.ofNullable(bundle.getGenericEntities()).orElse(Collections.emptyMap());
        return this.buildEntities(genericEntities, bundle, bundleType, document);
    }

    private List<Entity> buildEntities(Map<String, GenericEntity> genericEntities, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        switch (bundleType) {
            case DEPLOYMENT: {
                return genericEntities.entrySet().stream().map(entry -> EntityBuilderHelper.getEntityWithOnlyMapping("GENERIC", bundle.applyUniqueName((String)entry.getKey(), EntityBuilder.BundleType.ENVIRONMENT), this.generateId((GenericEntity)entry.getValue()))).collect(Collectors.toList());
            }
            case ENVIRONMENT: {
                return genericEntities.entrySet().stream().map(e -> this.buildGenericEntity(bundle.applyUniqueName((String)e.getKey(), bundleType), (GenericEntity)e.getValue(), document)).collect(Collectors.toList());
            }
        }
        throw new EntityBuilderException("Unknown bundle type: " + (Object)((Object)bundleType));
    }

    private Entity buildGenericEntity(String name, GenericEntity genericEntity, Document document) {
        String id = this.generateId(genericEntity);
        Element genericEntityElement = DocumentUtils.createElementWithAttributesAndChildren(document, "l7:GenericEntity", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)id), DocumentUtils.createElementWithTextContent(document, "l7:Name", name), DocumentUtils.createElementWithTextContent(document, "l7:Description", genericEntity.getDescription()), DocumentUtils.createElementWithTextContent(document, "l7:EntityClassName", genericEntity.getEntityClassName()), DocumentUtils.createElementWithTextContent(document, "l7:Enabled", Boolean.TRUE.toString()), DocumentUtils.createElementWithTextContent(document, "l7:ValueXml", genericEntity.getValueXml()));
        return EntityBuilderHelper.getEntityWithNameMapping("GENERIC", name, id, genericEntityElement);
    }

    private String generateId(GenericEntity genericEntity) {
        if (genericEntity != null && genericEntity.getAnnotatedEntity() != null && StringUtils.isNotBlank((CharSequence)genericEntity.getAnnotatedEntity().getId())) {
            return genericEntity.getAnnotatedEntity().getId();
        }
        return this.idGenerator.generate();
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }
}

