/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

class EntityBuilderHelper {
    private static final Logger LOGGER = Logger.getLogger(EntityBuilderHelper.class.getName());
    private static final String DEFAULT_ENTITY_MAPPING_ACTION = "NewOrUpdate";
    private static final String DEFAULT_ENTITY_MAPPING_ACTION_PROPERTY = "com.ca.apim.build.defaultEntityMappingAction";
    private static String defaultEntityMappingAction;

    private EntityBuilderHelper() {
    }

    @VisibleForTesting
    static void resetDefaultEntityMappingAction(String value) {
        defaultEntityMappingAction = null;
        System.setProperty(DEFAULT_ENTITY_MAPPING_ACTION_PROPERTY, value != null ? value : DEFAULT_ENTITY_MAPPING_ACTION);
    }

    static String getDefaultEntityMappingAction() {
        if (defaultEntityMappingAction == null) {
            String action = System.getProperty(DEFAULT_ENTITY_MAPPING_ACTION_PROPERTY);
            if (action == null || !Pattern.matches("NewOrExisting|NewOrUpdate", action)) {
                action = DEFAULT_ENTITY_MAPPING_ACTION;
            }
            defaultEntityMappingAction = action;
            LOGGER.info("Using default entity mapping action as " + defaultEntityMappingAction);
        }
        return defaultEntityMappingAction;
    }

    static Entity getEntityWithOnlyMapping(String entityType, String name, String id) {
        Entity entity = EntityBuilderHelper.getEntityWithNameMapping(entityType, name, id, null);
        entity.setMappingAction("NewOrExisting");
        entity.setMappingProperty("FailOnNew", true);
        return entity;
    }

    static Entity getEntityWithNameMapping(String type, String name, String id, Element element) {
        return EntityBuilderHelper.getEntityWithNameMapping(type, name, name, id, element, null, null);
    }

    static Entity getEntityWithNameMapping(String type, String originalName, String name, String id, Element element, String guid, GatewayEntity gatewayEntity) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bundleName", name);
        properties.put("guid", guid);
        Entity entity = new Entity(type, originalName, id, element, gatewayEntity);
        entity.setProperties(properties);
        entity.setMappingProperty("MapBy", "name");
        entity.setMappingProperty("MapTo", name);
        return entity;
    }

    static Entity getEntityWithPathMapping(String type, String originalPath, String pathInBundle, String id, Element element, boolean hasRouting, GatewayEntity gatewayEntity) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bundleName", pathInBundle);
        properties.put("hasRouting", hasRouting);
        Entity entity = new Entity(type, originalPath, id, element, gatewayEntity);
        entity.setProperties(properties);
        entity.setMappingProperty("MapBy", "path");
        entity.setMappingProperty("MapTo", pathInBundle);
        return entity;
    }

    @VisibleForTesting
    static Entity getEntityWithMappings(String type, String path, String id, Element element, String mappingAction, Map<String, Object> mappingProperties) {
        Entity entity = new Entity(type, path, id, element, null);
        entity.setMappingAction(mappingAction);
        mappingProperties.forEach(entity::setMappingProperty);
        String mapBy = (String)entity.getMappingProperties().get("MapBy");
        if ("path".equals(mapBy)) {
            entity.setMappingProperty("MapTo", path);
        } else if ("name".equals(mapBy)) {
            entity.setMappingProperty("MapTo", PathUtils.extractName(path));
        }
        return entity;
    }

    static Entity getEntityWithDeleteMappings(Entity entity) {
        return EntityBuilderHelper.getEntityWithMappings(entity.getType(), entity.getName(), entity.getId(), null, "Delete", entity.getMappingProperties());
    }

    static String getPath(Folder folder, String name) {
        return PathUtils.unixPath(EntityBuilderHelper.getPath(folder).toString(), name);
    }

    static Path getPath(Folder folder) {
        if (folder.getParentFolder() == null) {
            return Paths.get("", new String[0]);
        }
        return EntityBuilderHelper.getPath(folder.getParentFolder()).resolve(folder.getName());
    }
}

