/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.DependentBundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.MissingGatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.IdValidator;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class EncassEntityBuilder
implements EntityBuilder {
    private static final Logger LOGGER = Logger.getLogger(EncassEntityBuilder.class.getName());
    private static final int ORDER = 300;
    private final IdGenerator idGenerator;

    @Inject
    EncassEntityBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundle instanceof AnnotatedBundle) {
            AnnotatedBundle annotatedBundle = (AnnotatedBundle)bundle;
            Map map = Optional.ofNullable(annotatedBundle.getEncasses()).orElse(Collections.emptyMap());
            return this.buildEntities(map, annotatedBundle, annotatedBundle.getFullBundle(), bundleType, document);
        }
        return this.buildEntities(bundle.getEncasses(), null, bundle, bundleType, document);
    }

    private List<Entity> buildEntities(Map<String, ?> entities, AnnotatedBundle annotatedBundle, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundleType == EntityBuilder.BundleType.ENVIRONMENT) {
            return Collections.emptyList();
        }
        return entities.entrySet().stream().map(encassEntry -> this.buildEncassEntity(annotatedBundle, bundle, (String)encassEntry.getKey(), (Encass)encassEntry.getValue(), document)).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return 300;
    }

    private String getPolicyId(String policyWithPath, Bundle bundle, AnnotatedBundle annotatedBundle) {
        AtomicReference<Policy> includedPolicy = annotatedBundle != null ? new AtomicReference<Policy>(annotatedBundle.getPolicies().get(policyWithPath)) : new AtomicReference<Policy>(bundle.getPolicies().get(policyWithPath));
        if (includedPolicy.get() == null) {
            MissingGatewayEntity missingEntity;
            Set<Bundle> dependencies = bundle.getDependencies();
            if (dependencies != null) {
                dependencies.forEach(b -> {
                    Policy policyFromDependencies = Optional.ofNullable(b.getPolicies().get(policyWithPath)).orElse(b.getPolicies().get(PathUtils.extractName(policyWithPath)));
                    if (policyFromDependencies != null) {
                        if (!includedPolicy.compareAndSet(null, policyFromDependencies)) {
                            throw new EntityBuilderException("Found multiple policies in dependency bundles with policy path: " + policyWithPath);
                        }
                        DependentBundle dependentBundle = b.getDependentBundleFrom();
                        if (dependentBundle != null && dependentBundle.getType() != null) {
                            if (annotatedBundle != null) {
                                annotatedBundle.addDependentBundle(dependentBundle);
                            } else {
                                bundle.addDependentBundle(dependentBundle);
                            }
                        }
                    }
                });
            }
            if ((missingEntity = bundle.getMissingEntities().get(policyWithPath)) != null && missingEntity.isExcluded()) {
                LOGGER.log(Level.WARNING, "Resolving the referenced policy {0} as known excluded entity with guid: {1}", new Object[]{policyWithPath, missingEntity.getGuid()});
                includedPolicy.set(new Policy());
                includedPolicy.get().setGuid(missingEntity.getGuid());
            }
            if (includedPolicy.get() == null) {
                throw new EntityBuilderException("Could not find policy for encass. Policy Path: " + policyWithPath);
            }
        }
        return includedPolicy.get().getId();
    }

    private Entity buildEncassEntity(AnnotatedBundle annotatedBundle, Bundle bundle, String name, Encass encass, Document document) {
        String policyId = this.getPolicyId(encass.getPolicy(), bundle, annotatedBundle);
        String uniqueEncassName = name;
        String guid = encass.getGuid();
        String id = encass.getId();
        AnnotatedEntity annotatedEncassEntity = null;
        AnnotatedEntity<? extends GatewayEntity> annotatedEntity = annotatedBundle != null ? annotatedBundle.getAnnotatedEntity() : null;
        boolean isRedeployableBundle = false;
        boolean isShared = false;
        if (annotatedEntity != null) {
            isRedeployableBundle = annotatedEntity.isRedeployable();
            isShared = encass.isParentEntityShared();
            annotatedEncassEntity = encass.getAnnotatedEntity();
            if (isShared && annotatedEncassEntity != null) {
                if (annotatedEncassEntity.getGuid() != null) {
                    if (IdValidator.isValidGuid(annotatedEncassEntity.getGuid())) {
                        guid = annotatedEncassEntity.getGuid();
                    } else {
                        LOGGER.log(Level.WARNING, "ignoring given invalid guid {0} for entity {1}", new String[]{annotatedEncassEntity.getGuid(), name});
                    }
                }
                if (annotatedEncassEntity.getId() != null) {
                    if (IdValidator.isValidGoid(annotatedEncassEntity.getId())) {
                        id = annotatedEncassEntity.getId();
                    } else {
                        LOGGER.log(Level.WARNING, "ignoring given invalid goid {0} for entity {1}", new String[]{annotatedEncassEntity.getId(), name});
                    }
                }
            }
            uniqueEncassName = annotatedBundle.applyUniqueName(name, EntityBuilder.BundleType.DEPLOYMENT, isShared);
        }
        encass.setUniqueEntityName(uniqueEncassName);
        Element encassAssertionElement = DocumentUtils.createElementWithAttributesAndChildren(document, "l7:EncapsulatedAssertion", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)id), DocumentUtils.createElementWithTextContent(document, "l7:Name", uniqueEncassName), DocumentUtils.createElementWithTextContent(document, "l7:Guid", guid), DocumentUtils.createElementWithAttribute(document, "l7:PolicyReference", "id", policyId), this.buildArguments(encass, document), this.buildResults(encass, document));
        Map properties = Optional.ofNullable(encass.getProperties()).orElse(new HashMap());
        properties.putIfAbsent("paletteFolder", "internalAssertions");
        BuilderUtils.buildAndAppendPropertiesElement(properties, document, encassAssertionElement);
        Entity entity = EntityBuilderHelper.getEntityWithNameMapping("ENCAPSULATED_ASSERTION", name, uniqueEncassName, id, encassAssertionElement, guid, encass);
        if (isRedeployableBundle) {
            entity.setMappingAction("NewOrUpdate");
        } else if (isShared) {
            entity.setMappingAction("NewOrExisting");
        } else {
            entity.setMappingAction(EntityBuilderHelper.getDefaultEntityMappingAction());
        }
        return entity;
    }

    private Element buildResults(Encass encass, Document document) {
        Element encapsulatedResultsElement = document.createElement("l7:EncapsulatedResults");
        if (encass.getResults() != null) {
            encass.getResults().forEach(param -> encapsulatedResultsElement.appendChild(DocumentUtils.createElementWithChildren(document, "l7:EncapsulatedAssertionResult", DocumentUtils.createElementWithTextContent(document, "l7:ResultName", param.getName()), DocumentUtils.createElementWithTextContent(document, "l7:ResultType", param.getType()))));
        }
        return encapsulatedResultsElement;
    }

    private Element buildArguments(Encass encass, Document document) {
        Element encapsulatedArgumentsElement = document.createElement("l7:EncapsulatedArguments");
        if (encass.getArguments() != null) {
            AtomicInteger ordinal = new AtomicInteger(1);
            encass.getArguments().forEach(param -> encapsulatedArgumentsElement.appendChild(DocumentUtils.createElementWithChildren(document, "l7:EncapsulatedAssertionArgument", DocumentUtils.createElementWithTextContent(document, "l7:Ordinal", String.valueOf(ordinal.getAndIncrement())), DocumentUtils.createElementWithTextContent(document, "l7:ArgumentName", param.getName()), DocumentUtils.createElementWithTextContent(document, "l7:ArgumentType", param.getType()), DocumentUtils.createElementWithTextContent(document, "l7:GuiLabel", param.getLabel()), DocumentUtils.createElementWithTextContent(document, "l7:GuiPrompt", ((Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{param.getRequireExplicit(), Boolean.FALSE})).toString()))));
        }
        return encapsulatedArgumentsElement;
    }
}

