/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.ProjectInfo;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BuilderConstants;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleMetadata;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Metadata;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.environment.EnvironmentConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class BundleMetadataBuilder {
    private final IdGenerator idGenerator;

    @Inject
    public BundleMetadataBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public BundleMetadata build(AnnotatedBundle annotatedBundle, Bundle bundle, List<Entity> dependentEntities, ProjectInfo projectInfo) {
        if (annotatedBundle != null && annotatedBundle.getAnnotatedEntity() != null) {
            String bundleName;
            AnnotatedEntity<? extends GatewayEntity> annotatedEntity = annotatedBundle.getAnnotatedEntity();
            String name = bundleName = annotatedBundle.getBundleName();
            if (StringUtils.isNotBlank((CharSequence)projectInfo.getVersion())) {
                name = bundleName.substring(0, bundleName.indexOf(projectInfo.getVersion()) - 1);
            }
            BundleMetadata.Builder builder = new BundleMetadata.Builder(annotatedEntity.getEntityType(), name, projectInfo.getName(), projectInfo.getGroupName(), projectInfo.getVersion());
            builder.description(annotatedEntity.getDescription());
            Collection<Metadata> referencedEntities = this.getEnvironmentDependenciesMetadata(dependentEntities);
            builder.referencedEntities(referencedEntities);
            if (!referencedEntities.isEmpty()) {
                annotatedBundle.getDependentBundles().add(EnvironmentConfigurationUtils.generateDependentEnvBundleFromProject(projectInfo));
            }
            builder.dependencies(annotatedBundle.getDependentBundles());
            builder.tags(annotatedEntity.getTags());
            builder.redeployable(annotatedEntity.isRedeployable() || "NewOrUpdate".equals(EntityBuilderHelper.getDefaultEntityMappingAction()) && !this.isBundleContainsSharedEntity(annotatedBundle));
            builder.l7Template(annotatedEntity.isL7Template());
            builder.hasRouting(this.hasRoutingAssertion(dependentEntities));
            ArrayList<Metadata> definedEntities = new ArrayList<Metadata>();
            definedEntities.add(annotatedEntity.getEntity().getMetadata());
            return builder.definedEntities(definedEntities).build();
        }
        return this.buildFullBundleMetadata(dependentEntities, bundle, projectInfo);
    }

    public BundleMetadata buildEnvironmentMetadata(List<Entity> entities, ProjectInfo projectInfo) {
        boolean isConfigNamePresent = StringUtils.isNotBlank((CharSequence)projectInfo.getConfigName());
        String version = projectInfo.getVersion();
        if (StringUtils.isNotBlank((CharSequence)version) && isConfigNamePresent) {
            version = version + "-" + projectInfo.getConfigName();
        }
        String name = projectInfo.getName() + "-" + "environment";
        BundleMetadata.Builder builder = new BundleMetadata.Builder(EntityBuilder.BundleType.ENVIRONMENT.name(), name, projectInfo.getName(), projectInfo.getGroupName(), version);
        builder.description("");
        ArrayList<String> tags = new ArrayList<String>();
        if (isConfigNamePresent) {
            tags.add(projectInfo.getConfigName());
        }
        builder.tags(tags);
        builder.redeployable("NewOrUpdate".equals(EntityBuilderHelper.getDefaultEntityMappingAction()));
        builder.hasRouting(false);
        builder.definedEntities(this.getEnvironmentDependenciesMetadata(entities));
        return builder.build();
    }

    private BundleMetadata buildFullBundleMetadata(List<Entity> entities, Bundle bundle, ProjectInfo projectInfo) {
        BundleMetadata.Builder builder = new BundleMetadata.Builder("ALL", projectInfo.getName(), projectInfo.getName(), projectInfo.getGroupName(), projectInfo.getVersion());
        builder.description("");
        builder.tags(Collections.emptyList());
        builder.redeployable("NewOrUpdate".equals(EntityBuilderHelper.getDefaultEntityMappingAction()));
        builder.hasRouting(this.hasRoutingAssertion(entities));
        Collection<Metadata> referencedEntities = this.getEnvironmentDependenciesMetadata(entities);
        builder.referencedEntities(referencedEntities);
        if (!referencedEntities.isEmpty()) {
            bundle.getDependentBundles().add(EnvironmentConfigurationUtils.generateDependentEnvBundleFromProject(projectInfo));
        }
        builder.dependencies(bundle.getDependentBundles());
        builder.definedEntities(this.getDefinedEntitiesMetadata(entities));
        return builder.build();
    }

    private Collection<Metadata> getEnvironmentDependenciesMetadata(List<Entity> dependentEntities) {
        return dependentEntities.stream().filter(BuilderConstants.FILTER_ENV_ENTITIES).map(Entity::getMetadata).collect(Collectors.toList());
    }

    private Collection<Metadata> getDefinedEntitiesMetadata(List<Entity> definedEntities) {
        return definedEntities.stream().filter(BuilderConstants.FILTER_NON_ENV_ENTITIES_EXCLUDING_FOLDER).map(e -> e.getGatewayEntity().getMetadata()).collect(Collectors.toList());
    }

    private boolean isBundleContainsSharedEntity(AnnotatedBundle annotatedBundle) {
        return annotatedBundle.getEncasses().values().stream().anyMatch(Encass::isParentEntityShared) || annotatedBundle.getPolicies().values().stream().anyMatch(Policy::isParentEntityShared);
    }

    private boolean hasRoutingAssertion(List<Entity> dependentEntities) {
        return dependentEntities.stream().anyMatch(Entity::isHasRouting);
    }
}

