/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.DependentBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Metadata;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedList;

@JsonPropertyOrder(value={"metaVersion", "name", "groupName", "moduleName", "version", "timestamp", "type", "tags", "description", "l7Template", "redeployable", "hasRouting", "definedEntities", "referencedEntities", "dependencies"})
public class BundleMetadata
implements Metadata {
    private final String metaVersion = "1.0";
    private final String type;
    private final String name;
    private final String version;
    private final long timestamp = Instant.now().getEpochSecond();
    private final String moduleName;
    private final String groupName;
    private String description;
    private Collection<Metadata> definedEntities;
    private Collection<String> tags;
    private boolean l7Template;
    private boolean redeployable;
    private boolean hasRouting;
    private Collection<Metadata> referencedEntities;
    private Collection<DependentBundle> dependencies;

    private BundleMetadata(String type, String name, String moduleName, String groupName, String version) {
        this.type = type;
        this.name = name;
        this.moduleName = moduleName;
        this.groupName = groupName;
        this.version = version;
    }

    public String getMetaVersion() {
        return "1.0";
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return null;
    }

    @Override
    @JsonIgnore
    public String getGuid() {
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<Metadata> getDefinedEntities() {
        return this.definedEntities;
    }

    public Collection<String> getTags() {
        return this.tags;
    }

    public boolean isL7Template() {
        return this.l7Template;
    }

    public boolean isRedeployable() {
        return this.redeployable;
    }

    public boolean isHasRouting() {
        return this.hasRouting;
    }

    public Collection<Metadata> getReferencedEntities() {
        return this.referencedEntities;
    }

    public Collection<DependentBundle> getDependencies() {
        return this.dependencies;
    }

    public static class Builder {
        private final String name;
        private final String type;
        private String moduleName;
        private String groupName;
        private final String version;
        private String description;
        private boolean l7Template;
        private boolean redeployable;
        private boolean hasRouting;
        private Collection<String> tags;
        private Collection<Metadata> definedEntities = new LinkedList<Metadata>();
        private Collection<Metadata> referencedEntities = new LinkedList<Metadata>();
        private Collection<DependentBundle> dependencies = new LinkedList<DependentBundle>();

        public Builder(String type, String name, String moduleName, String groupName, String version) {
            this.type = type;
            this.name = name;
            this.moduleName = moduleName;
            this.groupName = groupName;
            this.version = version;
        }

        public Builder definedEntities(Collection<Metadata> entities) {
            this.definedEntities.clear();
            this.definedEntities.addAll(entities);
            return this;
        }

        public Builder referencedEntities(Collection<Metadata> referencedEntities) {
            this.referencedEntities.clear();
            this.referencedEntities.addAll(referencedEntities);
            return this;
        }

        public Builder dependencies(Collection<DependentBundle> dependencies) {
            this.dependencies.clear();
            this.dependencies.addAll(dependencies);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder redeployable(boolean redeployable) {
            this.redeployable = redeployable;
            return this;
        }

        public Builder l7Template(boolean l7Template) {
            this.l7Template = l7Template;
            return this;
        }

        public Builder hasRouting(boolean hasRouting) {
            this.hasRouting = hasRouting;
            return this;
        }

        public Builder tags(Collection<String> tags) {
            this.tags = tags;
            return this;
        }

        public BundleMetadata build() {
            BundleMetadata bundleMetadata = new BundleMetadata(this.type, this.name, this.moduleName, this.groupName, this.version);
            bundleMetadata.description = this.description;
            bundleMetadata.definedEntities = this.definedEntities;
            bundleMetadata.l7Template = this.l7Template;
            bundleMetadata.redeployable = this.redeployable;
            bundleMetadata.hasRouting = this.hasRouting;
            bundleMetadata.tags = this.tags;
            bundleMetadata.referencedEntities = this.referencedEntities;
            bundleMetadata.dependencies = this.dependencies;
            return bundleMetadata;
        }
    }
}

