/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.ProjectInfo;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Dependency;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.EntityTypeRegistry;
import com.ca.apim.gateway.cagatewayconfig.beans.EntityUtils;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.Folderable;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.beans.PrivateKey;
import com.ca.apim.gateway.cagatewayconfig.beans.UnsupportedGatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotableEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BuilderConstants;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleArtifacts;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleDocumentBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleMetadata;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleMetadataBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PrivateKeyImportContextBuilder;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class BundleEntityBuilder {
    private static final Logger LOGGER = Logger.getLogger(BundleEntityBuilder.class.getName());
    private final Set<EntityBuilder> entityBuilders;
    private final BundleDocumentBuilder bundleDocumentBuilder;
    private final BundleMetadataBuilder bundleMetadataBuilder;
    private final PrivateKeyImportContextBuilder privateKeyImportContextBuilder;
    private final EntityTypeRegistry entityTypeRegistry;

    @Inject
    BundleEntityBuilder(Set<EntityBuilder> entityBuilders, BundleDocumentBuilder bundleDocumentBuilder, BundleMetadataBuilder bundleMetadataBuilder, EntityTypeRegistry entityTypeRegistry, PrivateKeyImportContextBuilder privateKeyImportContextBuilder) {
        this.entityBuilders = Collections.unmodifiableSet(new TreeSet<EntityBuilder>(entityBuilders));
        this.bundleDocumentBuilder = bundleDocumentBuilder;
        this.bundleMetadataBuilder = bundleMetadataBuilder;
        this.entityTypeRegistry = entityTypeRegistry;
        this.privateKeyImportContextBuilder = privateKeyImportContextBuilder;
    }

    public Map<String, BundleArtifacts> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document, ProjectInfo projectInfo) {
        return this.build(bundle, bundleType, document, projectInfo, false);
    }

    public Map<String, BundleArtifacts> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document, ProjectInfo projectInfo, boolean generateMetadata) {
        Map<String, BundleArtifacts> artifacts;
        if (Bundle.isEnvironmentEntityUniqueNamingDisabled()) {
            LOGGER.log(Level.WARNING, "Environment entity unique-naming is disabled");
        }
        if ((artifacts = this.buildAnnotatedEntities(bundleType, bundle, document, projectInfo)).isEmpty()) {
            ArrayList<Entity> entities = new ArrayList<Entity>();
            this.entityBuilders.forEach(builder -> entities.addAll(builder.build(bundle, bundleType, document)));
            Element fullBundle = this.bundleDocumentBuilder.build(document, entities);
            BundleMetadata bundleMetadata = null;
            Element deleteBundleElement = null;
            String bundleNamePrefix = StringUtils.isBlank((CharSequence)projectInfo.getVersion()) ? projectInfo.getName() : projectInfo.getName() + "-" + projectInfo.getVersion();
            String bundleFileName = "";
            String deleteBundleFileName = "";
            if (bundleType == EntityBuilder.BundleType.DEPLOYMENT) {
                bundleMetadata = this.bundleMetadataBuilder.build(null, bundle, entities, projectInfo);
                deleteBundleElement = this.createDeleteBundle(document, entities, bundle, null, projectInfo);
                bundleFileName = this.generateBundleFileName(false, bundleNamePrefix);
                deleteBundleFileName = this.generateBundleFileName(true, bundleNamePrefix);
            } else if (bundleType == EntityBuilder.BundleType.ENVIRONMENT) {
                if (generateMetadata) {
                    bundleMetadata = this.bundleMetadataBuilder.buildEnvironmentMetadata(entities, projectInfo);
                }
                deleteBundleElement = this.createDeleteEnvBundle(document, entities);
            }
            BundleArtifacts bundleArtifacts = new BundleArtifacts(fullBundle, deleteBundleElement, bundleMetadata, bundleFileName, deleteBundleFileName);
            this.addPrivateKeyContexts(bundle, projectInfo, bundleArtifacts, document);
            artifacts.put(bundleNamePrefix, bundleArtifacts);
        }
        return artifacts;
    }

    private Map<String, BundleArtifacts> buildAnnotatedEntities(EntityBuilder.BundleType bundleType, Bundle bundle, Document document, ProjectInfo projectInfo) {
        LinkedHashMap<String, BundleArtifacts> annotatedElements = new LinkedHashMap<String, BundleArtifacts>();
        Map<String, EntityUtils.GatewayEntityInfo> entityTypeMap = this.entityTypeRegistry.getEntityTypeMap();
        entityTypeMap.values().stream().filter(EntityUtils.GatewayEntityInfo::isBundleGenerationSupported).forEach(entityInfo -> bundle.getEntities(entityInfo.getEntityClass()).values().stream().filter(entity -> entity instanceof AnnotableEntity && ((AnnotableEntity)((Object)entity)).isBundle()).forEach(gatewayEntity -> {
            AnnotatedEntity annotatedEntity = gatewayEntity instanceof Encass ? new Encass((Encass)gatewayEntity).getAnnotatedEntity() : ((AnnotableEntity)((Object)gatewayEntity)).getAnnotatedEntity();
            ArrayList<Entity> entities = new ArrayList<Entity>();
            AnnotatedBundle annotatedBundle = new AnnotatedBundle(bundle, annotatedEntity, projectInfo);
            Map<String, ?> bundleEntities = annotatedBundle.getEntities(((GatewayEntity)annotatedEntity.getEntity()).getClass());
            bundleEntities.put(annotatedEntity.getEntityName(), annotatedEntity.getEntity());
            this.loadPolicyDependenciesByPolicyName(annotatedEntity.getPolicyName(), annotatedBundle, bundle, false, false);
            this.entityBuilders.forEach(builder -> entities.addAll(builder.build(annotatedBundle, bundleType, document)));
            Element bundleElement = this.bundleDocumentBuilder.build(document, entities);
            String bundleFilename = "";
            String deleteBundleFilename = "";
            Element deleteBundleElement = null;
            if (EntityBuilder.BundleType.DEPLOYMENT.equals((Object)bundleType)) {
                deleteBundleElement = this.createDeleteBundle(document, entities, bundle, annotatedEntity, projectInfo);
                bundleFilename = this.generateBundleFileName(false, annotatedBundle.getBundleName());
                deleteBundleFilename = this.generateBundleFileName(true, annotatedBundle.getBundleName());
            }
            BundleMetadata bundleMetadata = null;
            if (bundleType == EntityBuilder.BundleType.DEPLOYMENT) {
                bundleMetadata = this.bundleMetadataBuilder.build(annotatedBundle, bundle, entities, projectInfo);
            }
            BundleArtifacts artifacts = new BundleArtifacts(bundleElement, deleteBundleElement, bundleMetadata, bundleFilename, deleteBundleFilename);
            this.addPrivateKeyContexts(annotatedBundle, projectInfo, artifacts, document);
            annotatedElements.put(annotatedBundle.getBundleName(), artifacts);
        }));
        return annotatedElements;
    }

    private Element createDeleteBundle(Document document, List<Entity> entities, Bundle bundle, AnnotatedEntity<GatewayEntity> annotatedEntity, ProjectInfo projectInfo) {
        List<Entity> deleteBundleEntities = this.copyFilteredEntitiesForDeleteBundle(entities, BuilderConstants.FILTER_NON_ENV_ENTITIES);
        if (annotatedEntity != null && !annotatedEntity.isRedeployable()) {
            AnnotatedBundle annotatedBundle = new AnnotatedBundle(bundle, annotatedEntity, projectInfo);
            Map<String, ?> bundleEntities = annotatedBundle.getEntities(annotatedEntity.getEntity().getClass());
            bundleEntities.put(annotatedEntity.getEntityName(), annotatedEntity.getEntity());
            this.loadPolicyDependenciesByPolicyName(annotatedEntity.getPolicyName(), annotatedBundle, bundle, true, false);
            Iterator<Entity> it = deleteBundleEntities.iterator();
            while (it.hasNext()) {
                Entity entity = it.next();
                Class<? extends GatewayEntity> entityClass = this.entityTypeRegistry.getEntityClass(entity.getType());
                Map<String, ? extends GatewayEntity> entityMap = annotatedBundle.getEntities(entityClass);
                if (entityMap.containsKey(entity.getOriginalName())) continue;
                it.remove();
            }
        }
        deleteBundleEntities.forEach(e -> e.setMappingAction("Delete"));
        return this.bundleDocumentBuilder.build(document, deleteBundleEntities);
    }

    private Element createDeleteEnvBundle(Document document, List<Entity> entities) {
        List<Entity> filteredEntities = this.copyFilteredEntitiesForDeleteBundle(entities, BuilderConstants.FILTER_ENV_ENTITIES.and(BuilderConstants.FILTER_OUT_DEFAULT_LISTEN_PORTS).and(BuilderConstants.FILTER_OUT_PRIVATE_KEYS));
        filteredEntities.forEach(e -> e.setMappingAction("Delete"));
        return this.bundleDocumentBuilder.build(document, filteredEntities);
    }

    private List<Entity> copyFilteredEntitiesForDeleteBundle(List<Entity> entities, Predicate<Entity> entityFilter) {
        ArrayList<Entity> deleteBundleEntities = new ArrayList<Entity>();
        for (int i = entities.size() - 1; i >= 0; --i) {
            Entity entity = entities.get(i);
            if (!entityFilter.test(entity) || "FOLDER".equals(entity.getType())) continue;
            deleteBundleEntities.add(entity);
        }
        return deleteBundleEntities;
    }

    private void loadPolicyDependenciesByPolicyName(String policyNameWithPath, AnnotatedBundle annotatedBundle, Bundle rawBundle, boolean excludeShared, boolean isParentShared) {
        Policy policy = this.findPolicyByNameOrPath(policyNameWithPath, rawBundle);
        this.loadPolicyDependencies(policy, annotatedBundle, rawBundle, excludeShared, isParentShared);
    }

    private void loadPolicyDependencies(Policy policy, AnnotatedBundle annotatedBundle, Bundle rawBundle, boolean excludeShared, boolean isParentShared) {
        if (policy == null || this.excludeGatewayEntity(Policy.class, policy, annotatedBundle, excludeShared)) {
            return;
        }
        Policy policyCopy = new Policy(policy);
        this.loadFolderDependencies(annotatedBundle, policyCopy);
        isParentShared = isParentShared || policyCopy.isShared();
        policyCopy.setParentEntityShared(isParentShared);
        Map<String, Policy> annotatedPolicyMap = annotatedBundle.getEntities(Policy.class);
        annotatedPolicyMap.put(policyCopy.getPath(), policyCopy);
        Set<Dependency> dependencies = policyCopy.getUsedEntities();
        if (dependencies != null) {
            block8: for (Dependency dependency : dependencies) {
                switch (dependency.getType()) {
                    case "POLICY": {
                        Policy dependentPolicy = this.findPolicyByNameOrPath(dependency.getName(), rawBundle);
                        this.loadPolicyDependencies(dependentPolicy, annotatedBundle, rawBundle, excludeShared, isParentShared);
                        continue block8;
                    }
                    case "ENCAPSULATED_ASSERTION": {
                        Encass encass = rawBundle.getEncasses().get(dependency.getName());
                        this.loadEncassDependencies(encass, annotatedBundle, rawBundle, excludeShared, isParentShared);
                        continue block8;
                    }
                }
                this.loadGatewayEntity(dependency, annotatedBundle, rawBundle);
            }
        }
    }

    private void loadEncassDependencies(Encass encass, AnnotatedBundle annotatedBundle, Bundle rawBundle, boolean excludeShared, boolean isParentShared) {
        if (encass != null && !this.excludeGatewayEntity(Encass.class, encass, annotatedBundle, excludeShared)) {
            Encass encassCopy = new Encass(encass);
            isParentShared = isParentShared || encass.isShared();
            encassCopy.setParentEntityShared(isParentShared);
            annotatedBundle.getEncasses().put(encass.getName(), encassCopy);
            this.loadPolicyDependenciesByPolicyName(encassCopy.getPolicy(), annotatedBundle, rawBundle, excludeShared, isParentShared);
        }
    }

    private void loadFolderDependencies(AnnotatedBundle annotatedBundle, GatewayEntity policyEntity) {
        if (policyEntity instanceof Folderable) {
            Map<String, Folder> folderMap = annotatedBundle.getEntities(Folder.class);
            for (Folder folder = ((Folderable)policyEntity).getParentFolder(); folder != null; folder = folder.getParentFolder()) {
                folderMap.putIfAbsent(folder.getPath(), folder);
            }
        }
    }

    private void loadGatewayEntity(Dependency dependency, AnnotatedBundle annotatedBundle, Bundle rawBundle) {
        Class<? extends GatewayEntity> entityClass = this.entityTypeRegistry.getEntityClass(dependency.getType());
        if (entityClass != null) {
            Map<String, ? extends GatewayEntity> allEntitiesOfType = rawBundle.getEntities(entityClass);
            Optional<Map.Entry> optionalGatewayEntity = allEntitiesOfType.entrySet().stream().filter(e -> {
                GatewayEntity gatewayEntity = (GatewayEntity)e.getValue();
                if (gatewayEntity.getName() != null) {
                    return dependency.getName().equals(gatewayEntity.getName());
                }
                return dependency.getName().equals(PathUtils.extractName((String)e.getKey()));
            }).findFirst();
            Map<String, ? extends GatewayEntity> entityMap = annotatedBundle.getEntities(entityClass);
            optionalGatewayEntity.ifPresent(e -> entityMap.put((String)e.getKey(), (GatewayEntity)e.getValue()));
        } else {
            Map<String, UnsupportedGatewayEntity> unsupportedEntities = rawBundle.getUnsupportedEntities();
            Optional<Map.Entry> optionalGatewayEntity = unsupportedEntities.entrySet().stream().filter(e -> {
                UnsupportedGatewayEntity gatewayEntity = (UnsupportedGatewayEntity)e.getValue();
                return dependency.getName().equals(PathUtils.extractName((String)e.getKey())) && dependency.getType().equals(gatewayEntity.getType());
            }).findFirst();
            Map<String, UnsupportedGatewayEntity> entityMap = annotatedBundle.getUnsupportedEntities();
            optionalGatewayEntity.ifPresent(e -> entityMap.put(((UnsupportedGatewayEntity)e.getValue()).getMappingValue(), (UnsupportedGatewayEntity)e.getValue()));
        }
    }

    private boolean excludeGatewayEntity(Class<? extends GatewayEntity> entityType, GatewayEntity gatewayEntity, AnnotatedBundle annotatedBundle, boolean excludeShared) {
        return annotatedBundle.getEntities(entityType).containsKey(gatewayEntity.getName()) || this.excludeSharedOrPolicyEntity(gatewayEntity, annotatedBundle, excludeShared);
    }

    private boolean excludeSharedOrPolicyEntity(GatewayEntity gatewayEntity, AnnotatedBundle annotatedBundle, boolean excludeShared) {
        if (gatewayEntity instanceof AnnotableEntity && ((AnnotableEntity)((Object)gatewayEntity)).isShared() && excludeShared) {
            return true;
        }
        return gatewayEntity instanceof Policy && this.findPolicyByNameOrPath(gatewayEntity.getName(), annotatedBundle) != null;
    }

    private Policy findPolicyByNameOrPath(String policyNameOrPath, Bundle rawBundle) {
        for (String policyKey : rawBundle.getPolicies().keySet()) {
            if (!StringUtils.equalsAny((CharSequence)policyNameOrPath, (CharSequence[])new CharSequence[]{PathUtils.extractName(policyKey), policyKey})) continue;
            return rawBundle.getPolicies().get(policyKey);
        }
        return null;
    }

    private String generateBundleFileName(boolean isDeleteBundle, String bundleName) {
        String filenameSuffix = isDeleteBundle ? ".delete.bundle" : ".install.bundle";
        return bundleName + filenameSuffix;
    }

    public void addPrivateKeyContexts(Bundle bundle, ProjectInfo projectInfo, BundleArtifacts bundleArtifacts, Document document) {
        if (!bundle.getPrivateKeys().isEmpty()) {
            bundle.getPrivateKeys().forEach((alias, privateKey) -> {
                if (privateKey.getPrivateKeyFile() == null) {
                    privateKey.setPrivateKeyFile(bundle.getPrivateKeyFiles().get(privateKey.getAlias()));
                }
                if (privateKey.getPrivateKeyFile() != null) {
                    Element element = this.privateKeyImportContextBuilder.build((PrivateKey)privateKey, document);
                    String filename = this.generatePrivateKeyFileName((PrivateKey)privateKey, projectInfo);
                    bundleArtifacts.addPrivateKeyContext(element, filename);
                }
            });
        }
    }

    private String generatePrivateKeyFileName(PrivateKey privateKey, ProjectInfo projectInfo) {
        StringBuilder filename = new StringBuilder(projectInfo.getName()).append("-").append(privateKey.getAlias());
        if (StringUtils.isNotBlank((CharSequence)projectInfo.getVersion())) {
            filename.append("-").append(projectInfo.getVersion());
            if (StringUtils.isNotBlank((CharSequence)projectInfo.getConfigName())) {
                filename.append("-").append(projectInfo.getConfigName());
            }
        }
        return filename.append(".privatekey").toString();
    }

    @VisibleForTesting
    public Set<EntityBuilder> getEntityBuilders() {
        return this.entityBuilders;
    }
}

