/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.ProjectInfo;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.DependentBundle;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class AnnotatedBundle
extends Bundle {
    private Bundle fullBundle;
    private AnnotatedEntity<? extends GatewayEntity> annotatedEntity;
    private List<DependentBundle> dependentBundles = new ArrayList<DependentBundle>();

    public AnnotatedBundle(Bundle fullBundle, AnnotatedEntity<? extends GatewayEntity> annotatedEntity, ProjectInfo projectInfo) {
        super(projectInfo);
        this.fullBundle = fullBundle;
        this.annotatedEntity = annotatedEntity;
    }

    public AnnotatedEntity<? extends GatewayEntity> getAnnotatedEntity() {
        return this.annotatedEntity;
    }

    public void setAnnotatedEntity(AnnotatedEntity<? extends GatewayEntity> annotatedEntity) {
        this.annotatedEntity = annotatedEntity;
    }

    public Bundle getFullBundle() {
        return this.fullBundle;
    }

    public void setFullBundle(Bundle fullBundle) {
        this.fullBundle = fullBundle;
    }

    public String getBundleName() {
        String name = this.getAnnotatedBundleName();
        return StringUtils.isBlank((CharSequence)this.getProjectInfo().getVersion()) ? name : name + "-" + this.getProjectInfo().getVersion();
    }

    private String getAnnotatedBundleName() {
        if (StringUtils.isBlank((CharSequence)this.annotatedEntity.getBundleName())) {
            return this.getProjectInfo().getName() + "-" + PathUtils.extractName(this.annotatedEntity.getEntityName());
        }
        return this.annotatedEntity.getBundleName();
    }

    @Override
    public void addDependentBundle(DependentBundle dependentBundle) {
        this.dependentBundles.add(dependentBundle);
    }

    @Override
    public List<DependentBundle> getDependentBundles() {
        return this.dependentBundles;
    }

    @Override
    public String getNamespace(EntityBuilder.BundleType bundleType, boolean isShared) {
        if (isShared || EntityBuilder.BundleType.ENVIRONMENT == bundleType) {
            return super.getNamespace(bundleType, isShared);
        }
        StringBuilder namespace = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.getProjectInfo().getGroupName())) {
            namespace.append(this.getProjectInfo().getGroupName());
            namespace.append(".");
        }
        namespace.append(this.getAnnotatedBundleName());
        return namespace.toString();
    }
}

