/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Set;

public interface AnnotableEntity {
    public static final Annotation BUNDLE_ANNOTATION = new Annotation("@bundle");
    public static final Annotation SHARED_ANNOTATION = new Annotation("@shared");
    public static final Annotation REDEPLOYABLE_ANNOTATION = new Annotation("@redeployable");
    public static final Annotation EXCLUDE_ANNOTATION = new Annotation("@exclude");

    public AnnotatedEntity<GatewayEntity> getAnnotatedEntity();

    @JsonIgnore
    public String getEntityType();

    public Set<Annotation> getAnnotations();

    default public AnnotatedEntity<GatewayEntity> createAnnotatedEntity() {
        Set<Annotation> annotations = this.getAnnotations();
        if (annotations != null) {
            AnnotatedEntity<AnnotableEntity> annotatedEntity = new AnnotatedEntity<AnnotableEntity>(this);
            annotations.forEach(annotation -> {
                if ("@bundle".equalsIgnoreCase(annotation.getType())) {
                    annotatedEntity.setEntityType(this.getEntityType());
                } else if ("@bundle-hints".equalsIgnoreCase(annotation.getType())) {
                    annotatedEntity.setId(annotation.getId());
                    annotatedEntity.setGuid(annotation.getGuid());
                    if (this.getEntityType().equals("SERVICE") || this.getEntityType().equals("ENCAPSULATED_ASSERTION")) {
                        annotatedEntity.setTags(annotation.getTags());
                        annotatedEntity.setBundleName(annotation.getName());
                        annotatedEntity.setDescription(annotation.getDescription());
                    }
                }
            });
            return annotatedEntity;
        }
        return null;
    }

    @JsonIgnore
    default public boolean isBundle() {
        return this.getAnnotations() != null && this.getAnnotations().contains(BUNDLE_ANNOTATION);
    }

    @JsonIgnore
    default public boolean isRedeployable() {
        return this.getAnnotations() != null && this.getAnnotations().contains(REDEPLOYABLE_ANNOTATION);
    }

    @JsonIgnore
    default public boolean isShared() {
        return this.getAnnotations() != null && this.getAnnotations().contains(SHARED_ANNOTATION);
    }

    @JsonIgnore
    default public boolean isExcluded() {
        return this.getAnnotations() != null && this.getAnnotations().contains(EXCLUDE_ANNOTATION);
    }
}

