/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.Folderable;
import com.ca.apim.gateway.cagatewayconfig.beans.SoapResourceType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import javax.inject.Named;
import org.apache.commons.io.FilenameUtils;

@Named(value="SOAP_RESOURCE")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SoapResource
extends Folderable {
    private String rootUrl;
    private String type;
    @JsonIgnore
    private String content;

    public String getRootUrl() {
        return this.rootUrl;
    }

    public void setRootUrl(String rootUrl) {
        this.rootUrl = rootUrl;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTypeByExtension(String extension) {
        if (!extension.startsWith(".")) {
            extension = "." + extension;
        }
        if (SoapResourceType.WSDL.getExtension().equals(extension)) {
            this.setType(SoapResourceType.WSDL.getType());
            return;
        }
        if (SoapResourceType.XMLSCHEMA.getExtension().equals(extension)) {
            this.setType(SoapResourceType.XMLSCHEMA.getType());
            return;
        }
        throw new IllegalStateException("Unsupported Soap Resource file: " + this.getName());
    }

    @JsonIgnore
    public String getBaseName() {
        return FilenameUtils.getBaseName((String)this.rootUrl);
    }

    @JsonIgnore
    public String getFileName() {
        String extensionToCheck;
        String filename = FilenameUtils.getName((String)this.rootUrl);
        if (SoapResourceType.WSDL.getType().equals(this.type)) {
            extensionToCheck = SoapResourceType.WSDL.getExtension();
        } else if (SoapResourceType.XMLSCHEMA.getType().equals(this.type)) {
            extensionToCheck = SoapResourceType.XMLSCHEMA.getExtension();
        } else {
            throw new IllegalStateException("Unknown Soap Resource type: " + this.type);
        }
        if (!filename.endsWith(extensionToCheck)) {
            filename = filename + extensionToCheck;
        }
        return filename;
    }

    @JsonIgnore
    public String getExtensionByType() {
        if (SoapResourceType.WSDL.getType().equals(this.type)) {
            return SoapResourceType.WSDL.getExtension();
        }
        if (SoapResourceType.XMLSCHEMA.getType().equals(this.type)) {
            return SoapResourceType.XMLSCHEMA.getExtension();
        }
        throw new IllegalStateException("Unknown Soap Resource type: " + this.type);
    }
}

