/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Folderable;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.SoapResource;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotableEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotationDeserializer;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Metadata;
import com.ca.apim.gateway.cagatewayconfig.config.spec.BundleGeneration;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.config.spec.EnvironmentType;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Named(value="SERVICE")
@ConfigurationFile(name="services", type=ConfigurationFile.FileType.JSON_YAML)
@EnvironmentType(value="SERVICE")
@BundleGeneration
public class Service
extends Folderable
implements AnnotableEntity {
    private String guid;
    private String url;
    private String policy;
    private Set<String> httpMethods;
    private Map<String, Object> properties;
    @JsonDeserialize(using=AnnotationDeserializer.class)
    private Set<Annotation> annotations;
    @JsonIgnore
    private Element serviceDetailsElement;
    @JsonIgnore
    private Element policyXML;
    private Set<SoapResource> soapResources;
    private String soapVersion;
    private boolean wssProcessingEnabled;
    private String wsdlRootUrl;
    @JsonIgnore
    private AnnotatedEntity<? extends GatewayEntity> annotatedEntity;
    @JsonIgnore
    private boolean hasRouting;

    @Override
    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<Annotation> annotations) {
        this.annotations = annotations;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public Set<String> getHttpMethods() {
        return this.httpMethods;
    }

    public void setHttpMethods(Set<String> httpMethods) {
        this.httpMethods = httpMethods;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Element getServiceDetailsElement() {
        return this.serviceDetailsElement;
    }

    public void setServiceDetailsElement(Element serviceDetailsElement) {
        this.serviceDetailsElement = serviceDetailsElement;
    }

    public Element getPolicyXML() {
        return this.policyXML;
    }

    public void setPolicyXML(Element policyXML) {
        this.policyXML = policyXML;
    }

    @Override
    @JsonIgnore
    public String getPath() {
        return super.getPath();
    }

    @Override
    public String getMappingValue() {
        return this.getPath();
    }

    @Override
    public void preWrite(File configFolder, DocumentFileUtils documentFileUtils) {
        this.setPolicy(this.getPath());
    }

    public Set<SoapResource> getSoapResources() {
        return this.soapResources;
    }

    public void setSoapResources(Set<SoapResource> soapResources) {
        this.soapResources = soapResources;
    }

    public void addSoapResource(SoapResource wsdl) {
        if (this.soapResources == null) {
            this.soapResources = new LinkedHashSet<SoapResource>();
        }
        this.soapResources.add(wsdl);
    }

    public String getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public boolean isWssProcessingEnabled() {
        return this.wssProcessingEnabled;
    }

    public void setWssProcessingEnabled(boolean wssProcessingEnabled) {
        this.wssProcessingEnabled = wssProcessingEnabled;
    }

    public String getWsdlRootUrl() {
        return this.wsdlRootUrl;
    }

    public void setWsdlRootUrl(String wsdlRootUrl) {
        this.wsdlRootUrl = wsdlRootUrl;
    }

    public boolean isHasRouting() {
        return this.hasRouting;
    }

    public void setHasRouting(boolean hasRouting) {
        this.hasRouting = hasRouting;
    }

    public AnnotatedEntity getAnnotatedEntity() {
        if (this.annotatedEntity == null && this.annotations != null) {
            Map<String, Object> props;
            this.annotatedEntity = this.createAnnotatedEntity();
            if (StringUtils.isBlank((CharSequence)this.annotatedEntity.getDescription()) && (props = this.getProperties()) != null) {
                this.annotatedEntity.setDescription(props.getOrDefault("description", "").toString());
            }
            this.annotatedEntity.setPolicyName(this.getPolicy());
            this.annotatedEntity.setEntityName(this.getName());
        }
        return this.annotatedEntity;
    }

    @Override
    @JsonIgnore
    public Metadata getMetadata() {
        return new Metadata(){

            @Override
            public String getType() {
                return "SERVICE";
            }

            @Override
            public String getName() {
                return Service.this.getName();
            }

            @Override
            public String getId() {
                AnnotatedEntity annotatedEntity = Service.this.getAnnotatedEntity();
                if (annotatedEntity != null && StringUtils.isNotBlank((CharSequence)annotatedEntity.getId())) {
                    return annotatedEntity.getId();
                }
                return Service.this.getId();
            }

            @Override
            public String getGuid() {
                AnnotatedEntity annotatedEntity = Service.this.getAnnotatedEntity();
                if (annotatedEntity != null && StringUtils.isNotBlank((CharSequence)annotatedEntity.getGuid())) {
                    return annotatedEntity.getGuid();
                }
                return Service.this.getGuid();
            }

            public String getUri() {
                return Service.this.getUrl();
            }

            public boolean isSoap() {
                return Service.this.getSoapResources() != null && StringUtils.isNotBlank((CharSequence)Service.this.getWsdlRootUrl());
            }
        };
    }

    @Override
    public String getEntityType() {
        return "SERVICE";
    }

    @Override
    public void postLoad(String entityKey, Bundle bundle, File rootFolder, IdGenerator idGenerator) {
        this.setGuid(idGenerator.generateGuid());
        this.setId(idGenerator.generate());
        this.setName(entityKey);
    }
}

