/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Dependency;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.Folderable;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.PolicyType;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotableEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Metadata;
import com.ca.apim.gateway.cagatewayconfig.config.loader.ConfigLoadException;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.paths.PathUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Named(value="POLICY")
public class Policy
extends Folderable
implements AnnotableEntity {
    @JsonIgnore
    private String policyXML;
    @JsonIgnore
    private String guid;
    @JsonIgnore
    private Element policyDocument;
    @JsonIgnore
    private Set<Annotation> annotations = new HashSet<Annotation>();
    @JsonIgnore
    private final Set<Policy> dependencies = new HashSet<Policy>();
    private String tag;
    @JsonIgnore
    private String subtag;
    @JsonIgnore
    private PolicyType policyType;
    @JsonIgnore
    private Set<Dependency> usedEntities = new LinkedHashSet<Dependency>();
    @JsonIgnore
    private AnnotatedEntity<? extends GatewayEntity> annotatedEntity;
    private boolean hasRouting;
    @JsonIgnore
    private boolean parentEntityShared;

    public Policy() {
    }

    public Policy(Builder builder) {
        this.setName(builder.name);
        this.setId(builder.id);
        this.guid = builder.guid;
        this.policyXML = builder.policy;
        this.tag = builder.tag;
        this.subtag = builder.subtag;
        this.setParentFolder(builder.parentFolderId != null ? new Folder(builder.parentFolderId, null) : null);
    }

    public Policy(Policy otherPolicy) {
        this.merge(otherPolicy);
    }

    public Set<Dependency> getUsedEntities() {
        return this.usedEntities;
    }

    public void setUsedEntities(Set<Dependency> usedEntities) {
        this.usedEntities = usedEntities;
    }

    public String getPolicyXML() {
        return this.policyXML;
    }

    public void setPolicyXML(String policyXML) {
        this.policyXML = policyXML;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setPolicyDocument(Element policyDocument) {
        this.policyDocument = policyDocument;
    }

    public Element getPolicyDocument() {
        return this.policyDocument;
    }

    public Set<Policy> getDependencies() {
        return this.dependencies;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getSubtag() {
        return this.subtag;
    }

    public void setSubtag(String subtag) {
        this.subtag = subtag;
    }

    public PolicyType getPolicyType() {
        return this.policyType;
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<Annotation> annotations) {
        this.annotations = annotations;
    }

    public void setPolicyType(PolicyType policyType) {
        this.policyType = policyType;
    }

    public boolean isHasRouting() {
        return this.hasRouting;
    }

    public void setHasRouting(boolean hasRouting) {
        this.hasRouting = hasRouting;
    }

    public boolean isParentEntityShared() {
        return this.parentEntityShared;
    }

    public void setParentEntityShared(boolean parentEntityShared) {
        this.parentEntityShared = parentEntityShared;
    }

    Policy merge(Policy otherPolicy) {
        this.policyXML = (String)ObjectUtils.firstNonNull((Object[])new String[]{otherPolicy.policyXML, this.policyXML});
        this.setPath((String)ObjectUtils.firstNonNull((Object[])new String[]{otherPolicy.getPath(), this.getPath()}));
        this.setName((String)ObjectUtils.firstNonNull((Object[])new String[]{otherPolicy.getName(), this.getName()}));
        this.setParentFolder((Folder)ObjectUtils.firstNonNull((Object[])new Folder[]{otherPolicy.getParentFolder(), this.getParentFolder()}));
        this.guid = (String)ObjectUtils.firstNonNull((Object[])new String[]{otherPolicy.guid, this.guid});
        this.policyDocument = (Element)ObjectUtils.firstNonNull((Object[])new Element[]{otherPolicy.policyDocument, this.policyDocument});
        this.dependencies.addAll((Collection)ObjectUtils.firstNonNull((Object[])new Set[]{otherPolicy.dependencies, Collections.emptySet()}));
        this.setId((String)ObjectUtils.firstNonNull((Object[])new String[]{otherPolicy.getId(), this.getId()}));
        this.tag = (String)ObjectUtils.firstNonNull((Object[])new String[]{otherPolicy.tag, this.tag});
        this.subtag = (String)ObjectUtils.firstNonNull((Object[])new String[]{otherPolicy.subtag, this.subtag});
        this.policyType = (PolicyType)((Object)ObjectUtils.firstNonNull((Object[])new PolicyType[]{otherPolicy.policyType, this.policyType}));
        this.hasRouting = otherPolicy.hasRouting || this.hasRouting;
        this.usedEntities.addAll((Collection)ObjectUtils.firstNonNull((Object[])new Set[]{otherPolicy.usedEntities, Collections.emptySet()}));
        this.annotations.addAll((Collection)ObjectUtils.firstNonNull((Object[])new Set[]{otherPolicy.annotations, Collections.emptySet()}));
        return this;
    }

    static void checkRepeatedTags(Bundle bundle, PolicyType policyType) {
        HashSet errors = new HashSet();
        new HashMap<String, Policy>(bundle.getPolicies()).values().stream().filter(p -> p.getTag() != null).collect(Collectors.groupingBy(Policy::getTag, Collectors.mapping(Function.identity(), Collectors.toList()))).forEach((key, value) -> {
            if (value.size() > 1) {
                errors.add(String.format("Found more then one %s policy with tag '%s': [%s]", policyType.getType(), key, String.join((CharSequence)", ", value.stream().map(Folderable::getPath).collect(Collectors.toList()))));
            }
        });
        if (!errors.isEmpty()) {
            throw new ConfigLoadException(String.join((CharSequence)"\n", errors));
        }
    }

    @Override
    public void postLoad(String entityKey, Bundle bundle, @Nullable File rootFolder, IdGenerator idGenerator) {
        this.setPath(PathUtils.unixPath(this.getPath(), new String[0]));
    }

    public AnnotatedEntity getAnnotatedEntity() {
        if (this.annotatedEntity == null && this.annotations != null) {
            this.annotatedEntity = this.createAnnotatedEntity();
        }
        return this.annotatedEntity;
    }

    @VisibleForTesting
    public void setAnnotatedEntity(AnnotatedEntity annotatedEntity) {
        this.annotatedEntity = annotatedEntity;
    }

    @Override
    public String getEntityType() {
        return "POLICY";
    }

    @Override
    @JsonIgnore
    public Metadata getMetadata() {
        return new Metadata(){

            @Override
            public String getType() {
                return "POLICY";
            }

            @Override
            public String getName() {
                return Policy.this.getName();
            }

            @Override
            public String getId() {
                return Policy.this.getId();
            }

            @Override
            public String getGuid() {
                return Policy.this.getGuid();
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Policy)) {
            return false;
        }
        Policy policy = (Policy)o;
        return Objects.equals(this.getPath(), policy.getPath());
    }

    public int hashCode() {
        return Objects.hash(this.getPath());
    }

    public static class Builder {
        private String name;
        private String id;
        private String guid;
        private String policy;
        private String tag;
        private String subtag;
        private String parentFolderId;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setGuid(String guid) {
            this.guid = guid;
            return this;
        }

        public Builder setPolicy(String policy) {
            this.policy = policy;
            return this;
        }

        public Builder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder setSubtag(String subtag) {
            this.subtag = subtag;
            return this;
        }

        public Builder setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public Policy build() {
            return new Policy(this);
        }
    }
}

