/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.config.spec.BundleGeneration;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.config.spec.EnvironmentType;
import javax.inject.Named;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class EntityUtils {
    public static final GatewayEntityInfo NO_INFO = new GatewayEntityInfo();

    private EntityUtils() {
    }

    public static <E extends GatewayEntity> GatewayEntityInfo createEntityInfo(Class<E> entityClass) {
        String type = EntityUtils.getEntityType(entityClass);
        if (type != null) {
            Pair<String, ConfigurationFile.FileType> configFileInfo = EntityUtils.getEntityConfigFileInfo(entityClass);
            return new GatewayEntityInfo(type, entityClass, (String)configFileInfo.getLeft(), (ConfigurationFile.FileType)((Object)configFileInfo.getRight()), EntityUtils.getEntityEnvironmentType(entityClass));
        }
        return null;
    }

    public static <E extends GatewayEntity> String getEntityType(Class<E> entityClass) {
        Named named = entityClass.getAnnotation(Named.class);
        return named != null ? named.value() : null;
    }

    public static <E extends GatewayEntity> Pair<String, ConfigurationFile.FileType> getEntityConfigFileInfo(Class<E> entityClass) {
        ConfigurationFile configurationFile = entityClass.getAnnotation(ConfigurationFile.class);
        return configurationFile != null ? ImmutablePair.of((Object)configurationFile.name(), (Object)((Object)configurationFile.type())) : ImmutablePair.nullPair();
    }

    public static <E extends GatewayEntity> String getEntityEnvironmentType(Class<E> entityClass) {
        EnvironmentType environmentType = entityClass.getAnnotation(EnvironmentType.class);
        return environmentType != null ? environmentType.value() : null;
    }

    public static class GatewayEntityInfo {
        private String type;
        private Class<? extends GatewayEntity> entityClass;
        private String fileName;
        private ConfigurationFile.FileType fileType;
        private String environmentType;
        private boolean bundleGenerationSupported;

        private GatewayEntityInfo() {
        }

        private GatewayEntityInfo(String type, Class<? extends GatewayEntity> entityClass, String fileName, ConfigurationFile.FileType fileType, String environmentType) {
            this.type = type;
            this.entityClass = entityClass;
            this.fileName = fileName;
            this.fileType = fileType;
            this.environmentType = environmentType;
        }

        public String getType() {
            return this.type;
        }

        public Class<GatewayEntity> getEntityClass() {
            return this.entityClass;
        }

        public String getFileName() {
            return this.fileName;
        }

        public ConfigurationFile.FileType getFileType() {
            return this.fileType;
        }

        public String getEnvironmentType() {
            return this.environmentType;
        }

        public boolean isBundleGenerationSupported() {
            BundleGeneration bundleGeneration = this.entityClass.getAnnotation(BundleGeneration.class);
            return bundleGeneration != null;
        }
    }
}

