/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.EntityUtils;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.reflections.Reflections;

@Singleton
public class EntityTypeRegistry {
    public static final Set<String> NON_ENV_ENTITY_TYPES = new HashSet<String>();
    private final Map<String, EntityUtils.GatewayEntityInfo> entityTypeMap;

    @Inject
    public EntityTypeRegistry(@Named(value="Reflections_ConfigBuilderInjectionProvider") Reflections reflections) {
        HashMap entityTypes = new HashMap();
        reflections.getSubTypesOf(GatewayEntity.class).forEach(e -> {
            EntityUtils.GatewayEntityInfo info = EntityUtils.createEntityInfo(e);
            if (info != null) {
                entityTypes.put(info.getType(), info);
            }
        });
        this.entityTypeMap = Collections.unmodifiableMap(entityTypes);
    }

    public Class<? extends GatewayEntity> getEntityClass(String entityType) {
        return Optional.ofNullable(this.entityTypeMap.get(entityType)).orElse(EntityUtils.NO_INFO).getEntityClass();
    }

    public Map<String, EntityUtils.GatewayEntityInfo> getEntityTypeMap() {
        return this.entityTypeMap;
    }

    public Map<String, EntityUtils.GatewayEntityInfo> getEnvironmentEntityTypes() {
        return this.entityTypeMap.entrySet().stream().filter(entry -> !NON_ENV_ENTITY_TYPES.contains(((EntityUtils.GatewayEntityInfo)entry.getValue()).getType())).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (EntityUtils.GatewayEntityInfo)entry.getValue()));
    }

    static {
        NON_ENV_ENTITY_TYPES.add("FOLDER");
        NON_ENV_ENTITY_TYPES.add("POLICY");
        NON_ENV_ENTITY_TYPES.add("SERVICE");
        NON_ENV_ENTITY_TYPES.add("ENCAPSULATED_ASSERTION");
    }
}

