/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.EncassArgument;
import com.ca.apim.gateway.cagatewayconfig.beans.EncassResult;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotableEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotationDeserializer;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Metadata;
import com.ca.apim.gateway.cagatewayconfig.config.spec.BundleGeneration;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.config.spec.EnvironmentType;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Named(value="ENCAPSULATED_ASSERTION")
@ConfigurationFile(name="encass", type=ConfigurationFile.FileType.JSON_YAML)
@EnvironmentType(value="ENCAPSULATED_ASSERTION")
@BundleGeneration
public class Encass
extends GatewayEntity
implements AnnotableEntity {
    private String policy;
    private Set<EncassArgument> arguments;
    private Set<EncassResult> results;
    private Map<String, Object> properties = new HashMap<String, Object>();
    @JsonDeserialize(using=AnnotationDeserializer.class)
    private Set<Annotation> annotations = new HashSet<Annotation>();
    @JsonIgnore
    private String guid;
    @JsonIgnore
    private String policyId;
    @JsonIgnore
    private String path;
    @JsonIgnore
    private AnnotatedEntity<? extends GatewayEntity> annotatedEntity;
    @JsonIgnore
    private boolean parentEntityShared;
    @JsonIgnore
    private String uniqueEntityName;

    public Encass() {
    }

    public Encass(Encass otherEncass) {
        this.guid = (String)ObjectUtils.firstNonNull((Object[])new String[]{otherEncass.guid, this.guid});
        this.setName((String)ObjectUtils.firstNonNull((Object[])new String[]{otherEncass.getName(), this.getName()}));
        this.setId((String)ObjectUtils.firstNonNull((Object[])new String[]{otherEncass.getId(), this.getId()}));
        this.properties.putAll((Map)ObjectUtils.firstNonNull((Object[])new Map[]{otherEncass.properties, Collections.emptyMap()}));
        this.policy = (String)ObjectUtils.firstNonNull((Object[])new String[]{otherEncass.policy, this.policy});
        this.path = (String)ObjectUtils.firstNonNull((Object[])new String[]{otherEncass.path, this.path});
        this.arguments = (Set)ObjectUtils.firstNonNull((Object[])new Set[]{(Set)ObjectUtils.firstNonNull((Object[])new Set[]{otherEncass.arguments, Collections.emptySet()})});
        this.results = (Set)ObjectUtils.firstNonNull((Object[])new Set[]{(Set)ObjectUtils.firstNonNull((Object[])new Set[]{otherEncass.results, Collections.emptySet()})});
        this.policyId = (String)ObjectUtils.firstNonNull((Object[])new String[]{otherEncass.policyId, this.policyId});
        this.annotations.addAll((Collection)ObjectUtils.firstNonNull((Object[])new Set[]{otherEncass.annotations, Collections.emptySet()}));
    }

    public Set<EncassArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(Set<EncassArgument> arguments) {
        this.arguments = arguments;
    }

    public Set<EncassResult> getResults() {
        return this.results;
    }

    public void setResults(Set<EncassResult> results) {
        this.results = results;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<Annotation> annotations) {
        this.annotations = annotations;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isParentEntityShared() {
        return this.parentEntityShared;
    }

    public void setParentEntityShared(boolean parentEntityShared) {
        this.parentEntityShared = parentEntityShared;
    }

    public String getUniqueEntityName() {
        return this.uniqueEntityName;
    }

    public void setUniqueEntityName(String uniqueEntityName) {
        this.uniqueEntityName = uniqueEntityName;
    }

    @Override
    public void postLoad(String entityKey, Bundle bundle, File rootFolder, IdGenerator idGenerator) {
        this.setGuid(idGenerator.generateGuid());
        this.setId(idGenerator.generate());
        this.setName(entityKey);
    }

    @Override
    public void preWrite(File configFolder, DocumentFileUtils documentFileUtils) {
        this.sortArgumentsAndResults();
    }

    @Override
    @JsonIgnore
    public Metadata getMetadata() {
        return new Metadata(){

            @Override
            public String getType() {
                return "ENCAPSULATED_ASSERTION";
            }

            @Override
            public String getName() {
                if (StringUtils.isNotBlank((CharSequence)Encass.this.getUniqueEntityName())) {
                    return Encass.this.getUniqueEntityName();
                }
                return Encass.this.getName();
            }

            @Override
            public String getId() {
                AnnotatedEntity annotatedEntity = Encass.this.getAnnotatedEntity();
                if (annotatedEntity != null && StringUtils.isNotBlank((CharSequence)annotatedEntity.getId())) {
                    return annotatedEntity.getId();
                }
                return Encass.this.getId();
            }

            @Override
            public String getGuid() {
                AnnotatedEntity annotatedEntity = Encass.this.getAnnotatedEntity();
                if (annotatedEntity != null && StringUtils.isNotBlank((CharSequence)annotatedEntity.getGuid())) {
                    return annotatedEntity.getGuid();
                }
                return Encass.this.getGuid();
            }

            public Set<EncassArgument> getArguments() {
                return Encass.this.getArguments();
            }

            public Set<EncassResult> getResults() {
                return Encass.this.getResults();
            }
        };
    }

    @VisibleForTesting
    public void sortArgumentsAndResults() {
        this.setArguments(this.getArguments().stream().collect(Collectors.toCollection(() -> new TreeSet<EncassArgument>(Comparator.comparing(EncassArgument::getName)))));
        this.setResults(this.getResults().stream().collect(Collectors.toCollection(() -> new TreeSet<EncassResult>(Comparator.comparing(EncassResult::getName)))));
    }

    public AnnotatedEntity getAnnotatedEntity() {
        if (this.annotatedEntity == null && this.annotations != null) {
            Map<String, Object> props;
            this.annotatedEntity = this.createAnnotatedEntity();
            if (StringUtils.isBlank((CharSequence)this.annotatedEntity.getDescription()) && (props = this.getProperties()) != null) {
                this.annotatedEntity.setDescription(props.getOrDefault("description", "").toString());
            }
            this.annotatedEntity.setPolicyName(this.getPolicy());
            this.annotatedEntity.setEntityName(this.getName());
        }
        return this.annotatedEntity;
    }

    @VisibleForTesting
    public void setAnnotatedEntity(AnnotatedEntity<Encass> annotatedEntity) {
        this.annotatedEntity = annotatedEntity;
    }

    @Override
    public String getEntityType() {
        return "ENCAPSULATED_ASSERTION";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Encass)) {
            return false;
        }
        Encass encass = (Encass)o;
        return Objects.equals(this.getName(), encass.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }
}

