/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotableEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotationDeserializer;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.config.spec.EnvironmentType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Named(value="CASSANDRA_CONFIGURATION")
@ConfigurationFile(name="cassandra-connections", type=ConfigurationFile.FileType.JSON_YAML)
@EnvironmentType(value="CASSANDRA_CONNECTION")
public class CassandraConnection
extends GatewayEntity
implements AnnotableEntity {
    private String keyspace;
    private String contactPoint;
    private Integer port;
    private String username;
    @JsonIgnore
    private String passwordId;
    private String storedPasswordName;
    private String compression;
    private Boolean ssl;
    private Set<String> tlsCiphers;
    private Map<String, Object> properties;
    @JsonDeserialize(using=AnnotationDeserializer.class)
    private Set<Annotation> annotations;
    @JsonIgnore
    private AnnotatedEntity<? extends GatewayEntity> annotatedEntity;

    @Override
    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<Annotation> annotations) {
        this.annotations = annotations;
    }

    public AnnotatedEntity getAnnotatedEntity() {
        if (this.annotatedEntity == null && this.annotations != null) {
            this.annotatedEntity = this.createAnnotatedEntity();
        }
        return this.annotatedEntity;
    }

    @Override
    public String getEntityType() {
        return "CASSANDRA_CONFIGURATION";
    }

    @VisibleForTesting
    public void setAnnotatedEntity(AnnotatedEntity<Encass> annotatedEntity) {
        this.annotatedEntity = annotatedEntity;
    }

    public CassandraConnection() {
    }

    private CassandraConnection(Builder builder) {
        this.setName(builder.name);
        this.setId(builder.id);
        this.contactPoint = builder.contactPoint;
        this.port = builder.port;
        this.username = builder.username;
        this.passwordId = builder.passwordId;
        this.compression = builder.compression;
        this.ssl = builder.ssl;
        this.tlsCiphers = builder.tlsCiphers;
        this.properties = builder.properties;
        this.keyspace = builder.keyspace;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getContactPoint() {
        return this.contactPoint;
    }

    public void setContactPoint(String contactPoint) {
        this.contactPoint = contactPoint;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getStoredPasswordName() {
        return this.storedPasswordName;
    }

    public void setStoredPasswordName(String storedPasswordName) {
        this.storedPasswordName = storedPasswordName;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public Boolean getSsl() {
        return this.ssl;
    }

    public void setSsl(Boolean ssl) {
        this.ssl = ssl;
    }

    public Set<String> getTlsCiphers() {
        return this.tlsCiphers;
    }

    public void setTlsCiphers(Set<String> tlsCiphers) {
        this.tlsCiphers = tlsCiphers;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public String getPasswordId() {
        return this.passwordId;
    }

    public void setPasswordId(String passwordId) {
        this.passwordId = passwordId;
    }

    public static class Builder {
        private String name;
        private String id;
        private String keyspace;
        private String contactPoint;
        private Integer port;
        private String username;
        private String passwordId;
        private String compression;
        private Boolean ssl;
        private Set<String> tlsCiphers;
        private Map<String, Object> properties;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder contactPoint(String contactPoint) {
            this.contactPoint = contactPoint;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder passwordId(String passwordId) {
            this.passwordId = passwordId;
            return this;
        }

        public Builder compression(String compression) {
            this.compression = compression;
            return this;
        }

        public Builder ssl(Boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder tlsCiphers(Set<String> tlsCiphers) {
            this.tlsCiphers = tlsCiphers;
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public Builder keyspace(String keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public CassandraConnection build() {
            return new CassandraConnection(this);
        }
    }
}

