/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig;

import org.apache.commons.lang3.StringUtils;

public class ProjectInfo {
    private final String name;
    private final String groupName;
    private final String version;
    private String majorVersion;
    private String minorVersion;
    private final String configName;
    private String targetFolderPath;

    public ProjectInfo(String name, String groupName, String version) {
        this(name, groupName, version, null);
    }

    public ProjectInfo(String name, String groupName, String version, String configName) {
        this.name = name;
        this.groupName = groupName;
        this.version = StringUtils.equalsIgnoreCase((CharSequence)version, (CharSequence)"unspecified") ? "" : version;
        this.configName = configName;
        if (StringUtils.isNotBlank((CharSequence)this.version)) {
            String[] versionParts = this.version.split("\\.");
            if (versionParts.length > 0) {
                this.majorVersion = versionParts[0];
                this.minorVersion = "0";
            } else {
                this.majorVersion = "";
                this.minorVersion = "";
            }
            if (versionParts.length > 1) {
                this.minorVersion = versionParts[1];
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getTargetFolderPath() {
        return this.targetFolderPath;
    }

    public void setTargetFolderPath(String targetFolderPath) {
        this.targetFolderPath = targetFolderPath;
    }
}

