/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.web.reactive.support;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.security.test.web.reactive.server.SecurityMockServerConfigurers;
import org.springframework.security.web.server.context.SecurityContextServerWebExchangeWebFilter;
import org.springframework.security.web.server.csrf.CsrfWebFilter;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;
import org.springframework.web.server.WebFilter;

public class WebTestClientSupport {
    private final MediaType defaultMediaType;
    private final Charset defaultCharset;
    private final List<WebTestClientConfigurer> configurers;
    private final Object[] controller;

    public WebTestClientSupport(MediaType defaultMediaType, Charset defaultCharset, Object ... controller) {
        this.defaultMediaType = defaultMediaType;
        this.defaultCharset = defaultCharset;
        this.configurers = new ArrayList<WebTestClientConfigurer>();
        this.controller = controller;
    }

    public WebTestClientSupport with(WebTestClientConfigurer configurer) {
        this.configurers.add(configurer);
        return this;
    }

    public WebTestClient.Builder clientBuilder() {
        WebTestClient.Builder builder = ((WebTestClient.ControllerSpec)((WebTestClient.ControllerSpec)WebTestClient.bindToController((Object[])this.controller).webFilter(new WebFilter[]{new CsrfWebFilter(), new SecurityContextServerWebExchangeWebFilter()})).apply(SecurityMockServerConfigurers.springSecurity())).configureClient();
        this.configurers.forEach(arg_0 -> ((WebTestClient.Builder)builder).apply(arg_0));
        return builder;
    }

    public WebTestClient client() {
        return this.clientBuilder().build();
    }

    public WebTestClient.ResponseSpec get(MediaType accept, String uriTemplate, Object ... uriVars) {
        return this.client().get().uri(uriTemplate, uriVars).accept(new MediaType[]{accept}).exchange();
    }

    public WebTestClient.ResponseSpec get(String uriTemplate, Object ... uriVars) {
        return this.get(this.defaultMediaType, uriTemplate, uriVars);
    }

    public <T> WebTestClient.ResponseSpec post(T payload, MediaType contentType, Charset charset, MediaType accept, String uriTemplate, Object ... uriVars) {
        return ((WebTestClient.RequestBodySpec)((WebTestClient.RequestBodySpec)this.client().post().uri(uriTemplate, uriVars)).accept(new MediaType[]{accept})).contentType(new MediaType(contentType, charset)).bodyValue(payload).exchange();
    }

    public <T> WebTestClient.ResponseSpec post(T payload, String uriTemplate, Object ... uriVars) {
        return this.post(payload, this.defaultMediaType, this.defaultCharset, this.defaultMediaType, uriTemplate, uriVars);
    }

    public <T> WebTestClient.ResponseSpec put(T payload, MediaType contentType, Charset charset, String uriTemplate, Object ... uriVars) {
        return ((WebTestClient.RequestBodySpec)this.client().put().uri(uriTemplate, uriVars)).contentType(new MediaType(contentType, charset)).bodyValue(payload).exchange();
    }

    public <T> WebTestClient.ResponseSpec put(T payload, String uriTemplate, Object ... uriVars) throws Exception {
        return this.put(payload, this.defaultMediaType, this.defaultCharset, uriTemplate, uriVars);
    }

    public <T> WebTestClient.ResponseSpec patch(T payload, MediaType contentType, Charset charset, String uriTemplate, Object ... uriVars) {
        return ((WebTestClient.RequestBodySpec)this.client().patch().uri(uriTemplate, uriVars)).contentType(new MediaType(contentType, charset)).bodyValue(payload).exchange();
    }

    public <T> WebTestClient.ResponseSpec patch(T payload, String uriTemplate, Object ... uriVars) throws Exception {
        return this.patch(payload, this.defaultMediaType, this.defaultCharset, uriTemplate, uriVars);
    }

    public <T> WebTestClient.ResponseSpec delete(String uriTemplate, Object ... uriVars) throws Exception {
        return this.client().delete().uri(uriTemplate, uriVars).exchange();
    }
}

