/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.web.servlet.request;

import com.c4_soft.springaddons.test.security.support.Defaults;
import com.c4_soft.springaddons.test.security.support.jwt.JwtAuthenticationTokenRequestPostProcessor;
import com.c4_soft.springaddons.test.security.web.servlet.request.ServletUnitTestingSupport;
import java.util.Collection;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;

@Import(value={UnitTestConfig.class})
public class ServletJwtAuthenticationTokenUnitTestingSupport
extends ServletUnitTestingSupport {
    public JwtAuthenticationTokenRequestPostProcessor authentication() {
        return (JwtAuthenticationTokenRequestPostProcessor)this.beanFactory.getBean(JwtAuthenticationTokenRequestPostProcessor.class);
    }

    @TestConfiguration
    public static class UnitTestConfig {
        @ConditionalOnMissingBean
        @Bean
        public JwtDecoder jwtDecoder() {
            return (JwtDecoder)Mockito.mock(JwtDecoder.class);
        }

        @ConditionalOnMissingBean
        @Bean
        @Scope(value="prototype")
        public Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter() {
            Jwt2AuthoritiesConverter mockAuthoritiesConverter = (Jwt2AuthoritiesConverter)Mockito.mock(Jwt2AuthoritiesConverter.class);
            Mockito.when((Object)((Collection)mockAuthoritiesConverter.convert((Jwt)ArgumentMatchers.any()))).thenReturn(Defaults.GRANTED_AUTHORITIES);
            return mockAuthoritiesConverter;
        }

        @Bean
        @Scope(value="prototype")
        public JwtAuthenticationTokenRequestPostProcessor jwtAuthenticationTokenRequestPostProcessor(Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter) {
            return new JwtAuthenticationTokenRequestPostProcessor(authoritiesConverter);
        }

        @Bean
        public ServletJwtAuthenticationTokenUnitTestingSupport testingSupport() {
            return new ServletJwtAuthenticationTokenUnitTestingSupport();
        }

        private static interface Jwt2AuthoritiesConverter
        extends Converter<Jwt, Collection<GrantedAuthority>> {
        }
    }
}

