/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.web.reactive.server;

import com.c4_soft.oauth2.rfc7519.JwtClaimSet;
import com.c4_soft.springaddons.test.security.support.Defaults;
import com.c4_soft.springaddons.test.security.support.jwt.JwtClaimSetAuthenticationWebTestClientConfigurer;
import com.c4_soft.springaddons.test.security.web.reactive.server.ReactiveUnitTestingSupport;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.JwtDecoder;

@Import(value={UnitTestConfig.class})
public class ReactiveJwtClaimSetAuthenticationUnitTestingSupport
extends ReactiveUnitTestingSupport {
    public JwtClaimSetAuthenticationWebTestClientConfigurer authentication() {
        return (JwtClaimSetAuthenticationWebTestClientConfigurer)this.beanFactory.getBean(JwtClaimSetAuthenticationWebTestClientConfigurer.class);
    }

    public JwtClaimSetAuthenticationWebTestClientConfigurer authentication(Consumer<JwtClaimSet.Builder<?>> claimsConsumer) {
        JwtClaimSetAuthenticationWebTestClientConfigurer webTestClientConfigurer = this.authentication();
        webTestClientConfigurer.claims(claimsConsumer);
        return webTestClientConfigurer;
    }

    @TestConfiguration
    public static class UnitTestConfig {
        @ConditionalOnMissingBean
        @Bean
        public JwtDecoder jwtDecoder() {
            return (JwtDecoder)Mockito.mock(JwtDecoder.class);
        }

        @ConditionalOnMissingBean
        @Bean
        @Scope(value="prototype")
        public Converter<Map<String, Object>, Set<GrantedAuthority>> authoritiesConverter() {
            JwtClaimSet2AuthoritiesConverter mockAuthoritiesConverter = (JwtClaimSet2AuthoritiesConverter)Mockito.mock(JwtClaimSet2AuthoritiesConverter.class);
            Mockito.when((Object)((Set)mockAuthoritiesConverter.convert((Map)ArgumentMatchers.any()))).thenReturn(Defaults.GRANTED_AUTHORITIES);
            return mockAuthoritiesConverter;
        }

        @Bean
        @Scope(value="prototype")
        public JwtClaimSetAuthenticationWebTestClientConfigurer jwtClaimSetAuthenticationWebTestClientConfigurer(Converter<Map<String, Object>, Set<GrantedAuthority>> authoritiesConverter) {
            return new JwtClaimSetAuthenticationWebTestClientConfigurer(authoritiesConverter);
        }

        private static interface JwtClaimSet2AuthoritiesConverter
        extends Converter<Map<String, Object>, Set<GrantedAuthority>> {
        }
    }
}

