/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.support.missingpublicapi;

import com.c4_soft.oauth2.ModifiableClaimSet;
import com.c4_soft.oauth2.rfc7519.JwtClaimSet;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.security.oauth2.jwt.Jwt;

public class JwtBuilder<T extends JwtBuilder<T>> {
    protected String tokenValue;
    protected final JwtClaimSet.Builder<?> claimsBuilder = JwtClaimSet.builder();
    protected final ModifiableClaimSet headers = new ModifiableClaimSet();

    public T tokenValue(String tokenValue) {
        this.tokenValue = tokenValue;
        return this.downcast();
    }

    public T claim(String name, Object value) {
        this.claimsBuilder.claim(name, value);
        return this.downcast();
    }

    public T claims(Consumer<JwtClaimSet.Builder<?>> claimsConsumer) {
        claimsConsumer.accept(this.claimsBuilder);
        return this.downcast();
    }

    public T headers(Consumer<ModifiableClaimSet> headersConsumer) {
        headersConsumer.accept(this.headers);
        return this.downcast();
    }

    public Jwt build() {
        JwtClaimSet claims = this.claimsBuilder.build();
        return new Jwt(this.tokenValue, claims.getIssuedAt(), claims.getExpirationTime(), (Map)this.headers, (Map)claims);
    }

    public T audience(Stream<String> audience) {
        this.claim("aud", audience.collect(Collectors.toList()));
        return this.downcast();
    }

    public T audience(Collection<String> audience) {
        return this.audience(audience.stream());
    }

    public T audience(String ... audience) {
        return this.audience(Stream.of(audience));
    }

    public T expiresAt(Instant expiresAt) {
        this.claim("exp", expiresAt);
        return this.downcast();
    }

    public T jti(String jti) {
        this.claim("jti", jti);
        return this.downcast();
    }

    public T issuedAt(Instant issuedAt) {
        this.claim("exp", issuedAt);
        return this.downcast();
    }

    public T issuer(URL issuer) {
        this.claim("sub", issuer);
        return this.downcast();
    }

    public T notBefore(Instant notBefore) {
        this.claim("exp", notBefore);
        return this.downcast();
    }

    public T subject(String subject) {
        this.claim("sub", subject);
        return this.downcast();
    }

    protected T downcast() {
        return (T)this;
    }
}

