/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.support.jwt;

import com.c4_soft.springaddons.test.security.support.AuthoritiesConverterNotAMockException;
import com.c4_soft.springaddons.test.security.support.jwt.JwtTestingBuilder;
import com.c4_soft.springaddons.test.security.support.missingpublicapi.JwtAuthenticationTokenBuilder;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class JwtAuthenticationTokenTestingBuilder<T extends JwtAuthenticationTokenTestingBuilder<T>>
extends JwtAuthenticationTokenBuilder<T> {
    @Autowired
    public JwtAuthenticationTokenTestingBuilder(Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter) {
        super(new JwtTestingBuilder(), authoritiesConverter);
    }

    public T authorities(Stream<String> authorities) {
        Collection grantedAuthorities = authorities.map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
        try {
            Mockito.when((Object)((Collection)this.authoritiesConverter.convert((Object)((Jwt)ArgumentMatchers.any())))).thenReturn((Object)grantedAuthorities);
        }
        catch (RuntimeException e) {
            throw new AuthoritiesConverterNotAMockException();
        }
        return (T)((JwtAuthenticationTokenTestingBuilder)this.downcast());
    }

    public T authorities(String ... authorities) {
        return this.authorities(Stream.of(authorities));
    }

    @Override
    public JwtAuthenticationToken build() {
        Jwt token = this.jwt.build();
        return new JwtAuthenticationToken(token, this.getAuthorities(token));
    }
}

