/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.context.support;

import com.c4_soft.springaddons.test.security.context.support.StringAttribute;
import com.c4_soft.springaddons.test.security.context.support.StringAttributeParserSupport;
import com.c4_soft.springaddons.test.security.support.introspection.BearerTokenAuthenticationTestingBuilder;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AliasFor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.test.context.support.TestExecutionEvent;
import org.springframework.security.test.context.support.WithSecurityContext;
import org.springframework.security.test.context.support.WithSecurityContextFactory;
import org.springframework.util.StringUtils;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@WithSecurityContext(factory=Factory.class)
public @interface WithMockIntrospectionToken {
    @AliasFor(value="authorities")
    public String[] value() default {"ROLE_USER"};

    @AliasFor(value="value")
    public String[] authorities() default {"ROLE_USER"};

    public String[] scopes() default {};

    public String tokenValue() default "Bearer test token";

    @AliasFor(value="subject")
    public String name() default "";

    @AliasFor(value="name")
    public String subject() default "";

    public StringAttribute[] attributes() default {};

    @AliasFor(annotation=WithSecurityContext.class)
    public TestExecutionEvent setupBefore() default TestExecutionEvent.TEST_METHOD;

    public static final class Factory
    implements WithSecurityContextFactory<WithMockIntrospectionToken> {
        private final StringAttributeParserSupport parsingSupport = new StringAttributeParserSupport();
        private final Converter<Map<String, Object>, Collection<GrantedAuthority>> authoritiesConverter;

        @Autowired
        public Factory(Converter<Map<String, Object>, Collection<GrantedAuthority>> authoritiesConverter) {
            this.authoritiesConverter = authoritiesConverter;
        }

        public SecurityContext createSecurityContext(WithMockIntrospectionToken annotation) {
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication((Authentication)this.authentication(annotation));
            return context;
        }

        public BearerTokenAuthentication authentication(WithMockIntrospectionToken annotation) {
            BearerTokenAuthenticationTestingBuilder auth = (BearerTokenAuthenticationTestingBuilder)new BearerTokenAuthenticationTestingBuilder(this.authoritiesConverter).token(accessToken -> accessToken.value(annotation.tokenValue()));
            this.parsingSupport.parse(annotation.attributes()).forEach((name, value) -> auth.attribute((String)name, value));
            Stream.of(annotation.scopes()).forEach(scope -> auth.token(accessToken -> accessToken.attributes(claims -> claims.scope(scope))));
            if (StringUtils.hasLength((String)annotation.name())) {
                auth.name(annotation.name());
            }
            if (annotation.authorities().length > 0) {
                auth.authorities(annotation.authorities());
            }
            return auth.build();
        }
    }
}

