/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.context.support;

import com.c4_soft.springaddons.test.security.context.support.AttributeValueParser;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface StringAttribute {
    public String name();

    public String value();

    public Class<? extends AttributeValueParser<String, ?>> parser() default NoOpParser.class;

    public static class UrlParser
    implements AttributeValueParser<String, URL> {
        @Override
        public URL parse(String value) {
            try {
                return StringUtils.isEmpty((Object)value) ? null : new URL(value);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class StringSetParser
    implements AttributeValueParser<String, Set<String>> {
        @Override
        public Set<String> parse(String value) {
            return Collections.singleton(StringUtils.isEmpty((Object)value) ? null : value);
        }
    }

    public static class StringListParser
    implements AttributeValueParser<String, List<String>> {
        @Override
        public List<String> parse(String value) {
            return Collections.singletonList(StringUtils.isEmpty((Object)value) ? null : value);
        }
    }

    public static class SpacedSeparatedStringsParser
    implements AttributeValueParser<String, Set<String>> {
        @Override
        public Set<String> parse(String value) {
            return StringUtils.isEmpty((Object)value) ? null : Stream.of(value.split(" ")).collect(Collectors.toSet());
        }
    }

    public static class NoOpParser
    implements AttributeValueParser<String, String> {
        @Override
        public String parse(String value) {
            return StringUtils.isEmpty((Object)value) ? null : value;
        }
    }

    public static class LongParser
    implements AttributeValueParser<String, Long> {
        @Override
        public Long parse(String value) {
            return StringUtils.isEmpty((Object)value) ? null : Long.valueOf(value);
        }
    }

    public static class IntegerParser
    implements AttributeValueParser<String, Integer> {
        @Override
        public Integer parse(String value) {
            return StringUtils.isEmpty((Object)value) ? null : Integer.valueOf(value);
        }
    }

    public static class InstantParser
    implements AttributeValueParser<String, Instant> {
        @Override
        public Instant parse(String value) {
            return StringUtils.isEmpty((Object)value) ? null : Instant.parse(value);
        }
    }

    public static class FloatParser
    implements AttributeValueParser<String, Float> {
        @Override
        public Float parse(String value) {
            return StringUtils.isEmpty((Object)value) ? null : Float.valueOf(value);
        }
    }

    public static class DoubleParser
    implements AttributeValueParser<String, Double> {
        @Override
        public Double parse(String value) {
            return StringUtils.isEmpty((Object)value) ? null : Double.valueOf(value);
        }
    }

    public static class BooleanParser
    implements AttributeValueParser<String, Boolean> {
        @Override
        public Boolean parse(String value) {
            return Boolean.valueOf(value);
        }
    }
}

