/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import com.c4_soft.springaddons.security.oidc.starter.LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsOauth2RedirectStrategy;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.util.StringUtils;

public class SpringAddonsLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    private final LogoutRequestUriBuilder uriBuilder;
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final SpringAddonsOauth2RedirectStrategy redirectStrategy;
    private final String defaultPostLogoutUri;

    public SpringAddonsLogoutSuccessHandler(LogoutRequestUriBuilder uriBuilder, ClientRegistrationRepository clientRegistrationRepository, SpringAddonsOidcProperties addonsProperties) {
        this.defaultPostLogoutUri = Optional.ofNullable(addonsProperties.getClient().getPostLogoutRedirectUri()).map(URI::toString).orElse(null);
        this.uriBuilder = uriBuilder;
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.redirectStrategy = new SpringAddonsOauth2RedirectStrategy(addonsProperties.getClient().getOauth2Redirections().getRpInitiatedLogout());
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        if (authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken oauth = (OAuth2AuthenticationToken)authentication;
            String postLogoutUri = Optional.ofNullable(request.getHeader("X-POST-LOGOUT-SUCCESS-URI")).orElse(Optional.ofNullable(request.getParameter("post_logout_success_uri")).orElse(this.defaultPostLogoutUri));
            ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(oauth.getAuthorizedClientRegistrationId());
            Optional<String> uri = StringUtils.hasText((String)postLogoutUri) ? this.uriBuilder.getLogoutRequestUri(clientRegistration, oauth.getName(), Optional.of(URI.create(postLogoutUri))) : this.uriBuilder.getLogoutRequestUri(clientRegistration, oauth.getName());
            return uri.orElse(null);
        }
        return null;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.redirectStrategy.sendRedirect(request, response, this.determineTargetUrl(request, response, authentication));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringAddonsLogoutSuccessHandler)) {
            return false;
        }
        SpringAddonsLogoutSuccessHandler other = (SpringAddonsLogoutSuccessHandler)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogoutRequestUriBuilder this$uriBuilder = this.uriBuilder;
        LogoutRequestUriBuilder other$uriBuilder = other.uriBuilder;
        if (this$uriBuilder == null ? other$uriBuilder != null : !this$uriBuilder.equals(other$uriBuilder)) {
            return false;
        }
        ClientRegistrationRepository this$clientRegistrationRepository = this.clientRegistrationRepository;
        ClientRegistrationRepository other$clientRegistrationRepository = other.clientRegistrationRepository;
        if (this$clientRegistrationRepository == null ? other$clientRegistrationRepository != null : !this$clientRegistrationRepository.equals(other$clientRegistrationRepository)) {
            return false;
        }
        SpringAddonsOauth2RedirectStrategy this$redirectStrategy = this.redirectStrategy;
        SpringAddonsOauth2RedirectStrategy other$redirectStrategy = other.redirectStrategy;
        if (this$redirectStrategy == null ? other$redirectStrategy != null : !this$redirectStrategy.equals(other$redirectStrategy)) {
            return false;
        }
        String this$defaultPostLogoutUri = this.defaultPostLogoutUri;
        String other$defaultPostLogoutUri = other.defaultPostLogoutUri;
        return !(this$defaultPostLogoutUri == null ? other$defaultPostLogoutUri != null : !this$defaultPostLogoutUri.equals(other$defaultPostLogoutUri));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SpringAddonsLogoutSuccessHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LogoutRequestUriBuilder $uriBuilder = this.uriBuilder;
        result = result * 59 + ($uriBuilder == null ? 43 : $uriBuilder.hashCode());
        ClientRegistrationRepository $clientRegistrationRepository = this.clientRegistrationRepository;
        result = result * 59 + ($clientRegistrationRepository == null ? 43 : $clientRegistrationRepository.hashCode());
        SpringAddonsOauth2RedirectStrategy $redirectStrategy = this.redirectStrategy;
        result = result * 59 + ($redirectStrategy == null ? 43 : $redirectStrategy.hashCode());
        String $defaultPostLogoutUri = this.defaultPostLogoutUri;
        result = result * 59 + ($defaultPostLogoutUri == null ? 43 : $defaultPostLogoutUri.hashCode());
        return result;
    }
}

