/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsClientMultiTenancyEnabled;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsClientWithLoginCondition;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.MultiTenantOAuth2PrincipalSupport;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.PropertySource;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.stereotype.Component;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Conditional(value={IsClientWithLoginCondition.class, IsClientMultiTenancyEnabled.class})
@AutoConfiguration
@PropertySource(value={"classpath:/c4-spring-addons.properties"}, ignoreResourceNotFound=true)
public class SpringAddonsAop {

    @Aspect
    @Component
    public static class AuthorizedClientAspect {
        private final OAuth2AuthorizedClientRepository authorizedClientRepo;

        @Pointcut(value="within(org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository+) && execution(* *.loadAuthorizedClient(..))")
        public void loadAuthorizedClient() {
        }

        @Pointcut(value="within(org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository+) && execution(* *.saveAuthorizedClient(..))")
        public void saveAuthorizedClient() {
        }

        @Pointcut(value="within(org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository+) && execution(* *.removeAuthorizedClient(..))")
        public void removeAuthorizedClient() {
        }

        @Pointcut(value="within(org.springframework.security.web.authentication.logout.LogoutHandler+) && execution(* *.logout(..))")
        public void logout() {
        }

        @Around(value="loadAuthorizedClient()")
        public Object aroundLoadAuthorizedClient(ProceedingJoinPoint jp) throws Throwable {
            String clientRegistrationId = (String)jp.getArgs()[0];
            Authentication principal = (Authentication)jp.getArgs()[1];
            HttpServletRequest request = (HttpServletRequest)jp.getArgs()[2];
            Object[] args = Stream.of(jp.getArgs()).toArray(Object[]::new);
            args[1] = MultiTenantOAuth2PrincipalSupport.getAuthentication(request.getSession(), clientRegistrationId).orElse(principal);
            return jp.proceed(args);
        }

        @AfterReturning(value="saveAuthorizedClient()")
        public void afterSaveAuthorizedClient(JoinPoint jp) {
            OAuth2AuthorizedClient authorizedClient = (OAuth2AuthorizedClient)jp.getArgs()[0];
            Authentication principal = (Authentication)jp.getArgs()[1];
            HttpServletRequest request = (HttpServletRequest)jp.getArgs()[2];
            String registrationId = authorizedClient.getClientRegistration().getRegistrationId();
            MultiTenantOAuth2PrincipalSupport.add(request.getSession(), registrationId, principal);
        }

        @Around(value="removeAuthorizedClient()")
        public Object aroundRemoveAuthorizedClient(ProceedingJoinPoint jp) throws Throwable {
            String clientRegistrationId = (String)jp.getArgs()[0];
            Authentication principal = (Authentication)jp.getArgs()[1];
            HttpServletRequest request = (HttpServletRequest)jp.getArgs()[2];
            Object[] args = Stream.of(jp.getArgs()).toArray(Object[]::new);
            args[1] = MultiTenantOAuth2PrincipalSupport.getAuthentication(request.getSession(), clientRegistrationId).orElse(principal);
            MultiTenantOAuth2PrincipalSupport.remove(request.getSession(), clientRegistrationId);
            return jp.proceed(args);
        }

        @Before(value="logout()")
        public void beforeServerLogoutHandlerLogout(JoinPoint jp) {
            HttpServletRequest request = (HttpServletRequest)jp.getArgs()[0];
            HttpServletResponse response = (HttpServletResponse)jp.getArgs()[1];
            for (Map.Entry<String, Authentication> e : MultiTenantOAuth2PrincipalSupport.getAuthenticationsByClientRegistrationId(request.getSession()).entrySet()) {
                this.authorizedClientRepo.removeAuthorizedClient(e.getKey(), e.getValue(), request, response);
            }
        }

        @Generated
        public AuthorizedClientAspect(OAuth2AuthorizedClientRepository authorizedClientRepo) {
            this.authorizedClientRepo = authorizedClientRepo;
        }
    }
}

